/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.nio.BytesChannelContext;
import org.elasticsearch.nio.ChannelFactory;
import org.elasticsearch.nio.Config;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.NioChannelHandler;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioServerSocketChannel;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.nio.Page;
import org.elasticsearch.nio.ServerChannelContext;
import org.elasticsearch.nio.SocketChannelContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpServerChannel;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.nio.NioGroupFactory;
import org.elasticsearch.transport.nio.NioTcpChannel;
import org.elasticsearch.transport.nio.NioTcpServerChannel;
import org.elasticsearch.transport.nio.NioTransport;
import org.elasticsearch.transport.nio.TcpReadWriteHandler;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.transport.ProfileConfigurations;
import org.elasticsearch.xpack.core.security.transport.SecurityTransportExceptionHandler;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.nio.NioIPFilter;
import org.elasticsearch.xpack.security.transport.nio.SSLChannelContext;
import org.elasticsearch.xpack.security.transport.nio.SSLDriver;

public class SecurityNioTransport
extends NioTransport {
    private static final Logger logger = LogManager.getLogger(SecurityNioTransport.class);
    private final SecurityTransportExceptionHandler exceptionHandler;
    private final IPFilter ipFilter;
    private final SSLService sslService;
    private final Map<String, SSLConfiguration> profileConfiguration;
    private final boolean sslEnabled;

    public SecurityNioTransport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, @Nullable IPFilter ipFilter, SSLService sslService, NioGroupFactory groupFactory) {
        super(settings, version, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, groupFactory);
        this.exceptionHandler = new SecurityTransportExceptionHandler(logger, this.lifecycle, (c, e) -> super.onException(c, e));
        this.ipFilter = ipFilter;
        this.sslService = sslService;
        this.sslEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        if (this.sslEnabled) {
            SSLConfiguration transportConfiguration = sslService.getSSLConfiguration(SecurityField.setting((String)"transport.ssl."));
            Map profileConfiguration = ProfileConfigurations.get((Settings)settings, (SSLService)sslService, (SSLConfiguration)transportConfiguration);
            this.profileConfiguration = Collections.unmodifiableMap(profileConfiguration);
        } else {
            this.profileConfiguration = Collections.emptyMap();
        }
    }

    protected void doStart() {
        super.doStart();
        if (this.ipFilter != null) {
            this.ipFilter.setBoundTransportAddress(this.boundAddress(), this.profileBoundAddresses());
        }
    }

    public void onException(TcpChannel channel, Exception e) {
        this.exceptionHandler.accept(channel, e);
    }

    protected NioTransport.TcpChannelFactory serverChannelFactory(TcpTransport.ProfileSettings profileSettings) {
        return new SecurityTcpChannelFactory(profileSettings, false);
    }

    protected Function<DiscoveryNode, NioTransport.TcpChannelFactory> clientChannelFactoryFunction(TcpTransport.ProfileSettings profileSettings) {
        return node -> {
            SNIHostName serverName;
            String configuredServerName = (String)node.getAttributes().get("server_name");
            if (configuredServerName != null) {
                try {
                    serverName = new SNIHostName(configuredServerName);
                }
                catch (IllegalArgumentException e) {
                    throw new ConnectTransportException(node, "invalid DiscoveryNode server_name [" + configuredServerName + "]", (Throwable)e);
                }
            } else {
                serverName = null;
            }
            return new SecurityClientTcpChannelFactory(profileSettings, serverName);
        };
    }

    public boolean isSecure() {
        return this.sslEnabled;
    }

    private class SecurityTcpChannelFactory
    extends NioTransport.TcpChannelFactory {
        private final String profileName;
        private final boolean isClient;

        private SecurityTcpChannelFactory(TcpTransport.ProfileSettings profileSettings, boolean isClient) {
            super(profileSettings);
            this.profileName = profileSettings.profileName;
            this.isClient = isClient;
        }

        public NioTcpChannel createChannel(NioSelector selector, SocketChannel channel, Config.Socket socketConfig) throws IOException {
            Object context;
            NioTcpChannel nioChannel = new NioTcpChannel(!this.isClient, this.profileName, channel);
            TcpReadWriteHandler readWriteHandler = new TcpReadWriteHandler(nioChannel, SecurityNioTransport.this.pageCacheRecycler, (TcpTransport)SecurityNioTransport.this);
            Object handler = SecurityNioTransport.this.ipFilter != null ? new NioIPFilter((NioChannelHandler)readWriteHandler, socketConfig.getRemoteAddress(), SecurityNioTransport.this.ipFilter, this.profileName) : readWriteHandler;
            InboundChannelBuffer networkBuffer = new InboundChannelBuffer((IntFunction)SecurityNioTransport.this.pageAllocator);
            Consumer<Exception> exceptionHandler = e -> SecurityNioTransport.this.onException((TcpChannel)nioChannel, (Exception)e);
            if (SecurityNioTransport.this.sslEnabled) {
                SSLDriver sslDriver = new SSLDriver(this.createSSLEngine(socketConfig), (IntFunction<Page>)SecurityNioTransport.this.pageAllocator, this.isClient);
                InboundChannelBuffer applicationBuffer = new InboundChannelBuffer((IntFunction)SecurityNioTransport.this.pageAllocator);
                context = new SSLChannelContext((NioSocketChannel)nioChannel, selector, socketConfig, exceptionHandler, sslDriver, (NioChannelHandler)handler, networkBuffer, applicationBuffer);
            } else {
                context = new BytesChannelContext((NioSocketChannel)nioChannel, selector, socketConfig, exceptionHandler, (NioChannelHandler)handler, networkBuffer);
            }
            nioChannel.setContext((SocketChannelContext)context);
            return nioChannel;
        }

        public NioTcpServerChannel createServerChannel(NioSelector selector, ServerSocketChannel channel, Config.ServerSocket socketConfig) {
            NioTcpServerChannel nioChannel = new NioTcpServerChannel(channel);
            Consumer<Exception> exceptionHandler = e -> SecurityNioTransport.this.onServerException((TcpServerChannel)nioChannel, e);
            Consumer<NioSocketChannel> acceptor = x$0 -> SecurityNioTransport.this.acceptChannel(x$0);
            ServerChannelContext context = new ServerChannelContext((NioServerSocketChannel)nioChannel, (ChannelFactory)this, selector, socketConfig, acceptor, exceptionHandler);
            nioChannel.setContext(context);
            return nioChannel;
        }

        protected SSLEngine createSSLEngine(Config.Socket socketConfig) throws IOException {
            SSLEngine sslEngine;
            SSLConfiguration defaultConfig = (SSLConfiguration)SecurityNioTransport.this.profileConfiguration.get("default");
            SSLConfiguration sslConfig = SecurityNioTransport.this.profileConfiguration.getOrDefault(this.profileName, defaultConfig);
            boolean hostnameVerificationEnabled = sslConfig.verificationMode().isHostnameVerificationEnabled();
            if (hostnameVerificationEnabled && !socketConfig.isAccepted()) {
                InetSocketAddress remoteAddress = socketConfig.getRemoteAddress();
                sslEngine = SecurityNioTransport.this.sslService.createSSLEngine(sslConfig, remoteAddress.getHostString(), remoteAddress.getPort());
            } else {
                sslEngine = SecurityNioTransport.this.sslService.createSSLEngine(sslConfig, null, -1);
            }
            return sslEngine;
        }
    }

    private class SecurityClientTcpChannelFactory
    extends SecurityTcpChannelFactory {
        private final SNIHostName serverName;

        private SecurityClientTcpChannelFactory(TcpTransport.ProfileSettings profileSettings, SNIHostName serverName) {
            super(profileSettings, true);
            this.serverName = serverName;
        }

        @Override
        public NioTcpServerChannel createServerChannel(NioSelector selector, ServerSocketChannel channel, Config.ServerSocket socketConfig) {
            throw new AssertionError((Object)"Cannot create TcpServerChannel with client factory");
        }

        @Override
        protected SSLEngine createSSLEngine(Config.Socket socketConfig) throws IOException {
            SSLEngine sslEngine = super.createSSLEngine(socketConfig);
            if (this.serverName != null) {
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                sslParameters.setServerNames(Collections.singletonList(this.serverName));
                sslEngine.setSSLParameters(sslParameters);
            }
            return sslEngine;
        }
    }
}

