/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.elasticsearch.nio.DelegatingHandler;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.NioChannelHandler;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;

public final class NioIPFilter
extends DelegatingHandler {
    private final InetSocketAddress remoteAddress;
    private final IPFilter filter;
    private final String profile;
    private boolean denied = false;

    NioIPFilter(NioChannelHandler delegate, InetSocketAddress remoteAddress, IPFilter filter, String profile) {
        super(delegate);
        this.remoteAddress = remoteAddress;
        this.filter = filter;
        this.profile = profile;
    }

    public void channelActive() {
        if (this.filter.accept(this.profile, this.remoteAddress)) {
            super.channelActive();
        } else {
            this.denied = true;
        }
    }

    public int consumeReads(InboundChannelBuffer channelBuffer) throws IOException {
        if (this.denied) {
            return 0;
        }
        return super.consumeReads(channelBuffer);
    }

    public boolean closeNow() {
        return this.denied;
    }
}

