/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.license.XPackLicenseState;

public class SecurityStatusChangeListener
implements LicenseStateListener {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final XPackLicenseState licenseState;
    private Boolean securityEnabled;

    public SecurityStatusChangeListener(XPackLicenseState licenseState) {
        this.licenseState = licenseState;
        this.securityEnabled = null;
    }

    public synchronized void licenseStateChanged() {
        boolean newState = this.licenseState.isSecurityEnabled();
        if (!Objects.equals(newState, this.securityEnabled)) {
            this.logger.info("Active license is now [{}]; Security is {}", (Object)this.licenseState.getOperationMode(), (Object)(newState ? "enabled" : "disabled"));
            if (!newState) {
                this.logger.warn("Elasticsearch built-in security features are not enabled. Without authentication, your cluster could be accessible to anyone. See https://www.elastic.co/guide/en/elasticsearch/reference/" + Version.CURRENT.major + "." + Version.CURRENT.minor + "/security-minimal-setup.html to enable security.");
            }
            this.securityEnabled = newState;
        }
    }
}

