/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.service;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.support.CacheIteratorHelper;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountToken;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountTokenStore;
import org.elasticsearch.xpack.security.support.CacheInvalidatorRegistry;

public abstract class CachingServiceAccountTokenStore
implements ServiceAccountTokenStore,
CacheInvalidatorRegistry.CacheInvalidator {
    private static final Logger logger = LogManager.getLogger(CachingServiceAccountTokenStore.class);
    public static final Setting<String> CACHE_HASH_ALGO_SETTING = Setting.simpleString((String)"xpack.security.authc.service_token.cache.hash_algo", (String)"ssha256", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting((String)"xpack.security.authc.service_token.cache.ttl", (TimeValue)TimeValue.timeValueMinutes((long)20L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> CACHE_MAX_TOKENS_SETTING = Setting.intSetting((String)"xpack.security.authc.service_token.cache.max_tokens", (int)100000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Settings settings;
    private final ThreadPool threadPool;
    private final Cache<String, ListenableFuture<CachedResult>> cache;
    private CacheIteratorHelper<String, ListenableFuture<CachedResult>> cacheIteratorHelper;
    private final Hasher hasher;

    CachingServiceAccountTokenStore(Settings settings, ThreadPool threadPool) {
        this.settings = settings;
        this.threadPool = threadPool;
        TimeValue ttl = (TimeValue)CACHE_TTL_SETTING.get(settings);
        if (ttl.getNanos() > 0L) {
            this.cache = CacheBuilder.builder().setExpireAfterWrite(ttl).setMaximumWeight((long)((Integer)CACHE_MAX_TOKENS_SETTING.get(settings)).intValue()).build();
            this.cacheIteratorHelper = new CacheIteratorHelper(this.cache);
        } else {
            this.cache = null;
            this.cacheIteratorHelper = null;
        }
        this.hasher = Hasher.resolve((String)((String)CACHE_HASH_ALGO_SETTING.get(settings)));
    }

    @Override
    public void authenticate(ServiceAccountToken token, ActionListener<Boolean> listener) {
        try {
            if (this.cache == null) {
                this.doAuthenticate(token, listener);
            } else {
                this.authenticateWithCache(token, listener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void authenticateWithCache(ServiceAccountToken token, ActionListener<Boolean> listener) {
        assert (this.cache != null);
        try {
            AtomicBoolean valueAlreadyInCache = new AtomicBoolean(true);
            ListenableFuture listenableCacheEntry = (ListenableFuture)this.cache.computeIfAbsent((Object)token.getQualifiedName(), k -> {
                valueAlreadyInCache.set(false);
                return new ListenableFuture();
            });
            if (valueAlreadyInCache.get()) {
                listenableCacheEntry.addListener(ActionListener.wrap(result -> {
                    if (((CachedResult)result).success) {
                        listener.onResponse((Object)((CachedResult)result).verify(token));
                    } else if (((CachedResult)result).verify(token)) {
                        listener.onResponse((Object)false);
                    } else {
                        this.cache.invalidate((Object)token.getQualifiedName(), (Object)listenableCacheEntry);
                        this.authenticateWithCache(token, listener);
                    }
                }, arg_0 -> listener.onFailure(arg_0)), this.threadPool.generic(), this.threadPool.getThreadContext());
            } else {
                this.doAuthenticate(token, (ActionListener<Boolean>)ActionListener.wrap(success -> {
                    if (!success.booleanValue()) {
                        this.cache.invalidate((Object)token.getQualifiedName(), (Object)listenableCacheEntry);
                    } else {
                        logger.trace("cache service token [{}] authentication result", (Object)token.getQualifiedName());
                    }
                    listenableCacheEntry.onResponse((Object)new CachedResult(this.hasher, (boolean)success, token));
                    listener.onResponse(success);
                }, e -> {
                    this.cache.invalidate((Object)token.getQualifiedName(), (Object)listenableCacheEntry);
                    listenableCacheEntry.onFailure(e);
                    listener.onFailure(e);
                }));
            }
        }
        catch (ExecutionException e2) {
            listener.onFailure((Exception)e2);
        }
    }

    @Override
    public final void invalidate(Collection<String> qualifiedTokenNames) {
        if (this.cache != null) {
            logger.trace("invalidating cache for service token [{}]", (Object)Strings.collectionToCommaDelimitedString(qualifiedTokenNames));
            for (String qualifiedTokenName : qualifiedTokenNames) {
                if (qualifiedTokenName.endsWith("/")) {
                    this.cacheIteratorHelper.removeKeysIf(key -> key.startsWith(qualifiedTokenName));
                    continue;
                }
                this.cache.invalidate((Object)qualifiedTokenName);
            }
        }
    }

    @Override
    public final void invalidateAll() {
        if (this.cache != null) {
            logger.trace("invalidating cache for all service tokens");
            this.cache.invalidateAll();
        }
    }

    protected Settings getSettings() {
        return this.settings;
    }

    protected ThreadPool getThreadPool() {
        return this.threadPool;
    }

    abstract void doAuthenticate(ServiceAccountToken var1, ActionListener<Boolean> var2);

    Cache<String, ListenableFuture<CachedResult>> getCache() {
        return this.cache;
    }

    static class CachedResult {
        private final boolean success;
        private final char[] hash;

        private CachedResult(Hasher hasher, boolean success, ServiceAccountToken token) {
            this.success = success;
            this.hash = hasher.hash(token.getSecret());
        }

        private boolean verify(ServiceAccountToken token) {
            return this.hash != null && Hasher.verifyHash((SecureString)token.getSecret(), (char[])this.hash);
        }
    }
}

