/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.service;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsRequest;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsResponse;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.authc.support.HttpTlsRuntimeCheck;

public class TransportGetServiceAccountCredentialsAction
extends HandledTransportAction<GetServiceAccountCredentialsRequest, GetServiceAccountCredentialsResponse> {
    private final ServiceAccountService serviceAccountService;
    private final HttpTlsRuntimeCheck httpTlsRuntimeCheck;
    private final String nodeName;

    @Inject
    public TransportGetServiceAccountCredentialsAction(TransportService transportService, ActionFilters actionFilters, Settings settings, ServiceAccountService serviceAccountService, HttpTlsRuntimeCheck httpTlsRuntimeCheck) {
        super("cluster:admin/xpack/security/service_account/credential/get", transportService, actionFilters, GetServiceAccountCredentialsRequest::new);
        this.nodeName = (String)Node.NODE_NAME_SETTING.get(settings);
        this.serviceAccountService = serviceAccountService;
        this.httpTlsRuntimeCheck = httpTlsRuntimeCheck;
    }

    protected void doExecute(Task task, GetServiceAccountCredentialsRequest request, ActionListener<GetServiceAccountCredentialsResponse> listener) {
        this.httpTlsRuntimeCheck.checkTlsThenExecute(arg_0 -> listener.onFailure(arg_0), "get service account tokens", () -> {
            ServiceAccount.ServiceAccountId accountId = new ServiceAccount.ServiceAccountId(request.getNamespace(), request.getServiceName());
            this.serviceAccountService.findTokensFor(accountId, this.nodeName, listener);
        });
    }
}

