/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.GetApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.GetApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class TransportGetApiKeyAction
extends HandledTransportAction<GetApiKeyRequest, GetApiKeyResponse> {
    private final ApiKeyService apiKeyService;
    private final SecurityContext securityContext;

    @Inject
    public TransportGetApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context) {
        super("cluster:admin/xpack/security/api_key/get", transportService, actionFilters, GetApiKeyRequest::new);
        this.apiKeyService = apiKeyService;
        this.securityContext = context;
    }

    protected void doExecute(Task task, GetApiKeyRequest request, ActionListener<GetApiKeyResponse> listener) {
        String apiKeyId = request.getApiKeyId();
        String apiKeyName = request.getApiKeyName();
        String username = request.getUserName();
        String realm = request.getRealmName();
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
        }
        if (request.ownedByAuthenticatedUser()) {
            assert (username == null);
            assert (realm == null);
            username = authentication.getUser().principal();
            realm = ApiKeyService.getCreatorRealmName(authentication);
        }
        this.apiKeyService.getApiKeys(realm, username, apiKeyName, apiKeyId, listener);
    }
}

