/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequestBuilder;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

public final class RestCreateApiKeyAction
extends ApiKeyBaseRestHandler {
    public RestCreateApiKeyAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerHandler(RestRequest.Method.POST, "/_security/api_key", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_security/api_key", (RestHandler)this);
    }

    public String getName() {
        return "xpack_security_create_api_key";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            String refresh = request.param("refresh");
            CreateApiKeyRequestBuilder builder = new SecurityClient((ElasticsearchClient)client).prepareCreateApiKey(request.requiredContent(), request.getXContentType()).setRefreshPolicy(refresh != null ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : CreateApiKeyRequest.DEFAULT_REFRESH_POLICY);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> builder.execute((ActionListener)new RestToXContentListener(channel));
            return restChannelConsumer;
        }
    }
}

