/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatch;
import org.elasticsearch.xpack.watcher.execution.Wid;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.support.init.proxy.WatcherClientProxy;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;

public class TriggeredWatchStore
extends AbstractComponent {
    public static final String INDEX_NAME = ".triggered_watches";
    public static final String DOC_TYPE = "doc";
    public static final String LEGACY_DOC_TYPE = "triggered_watch";
    private final int scrollSize;
    private final WatcherClientProxy client;
    private final TimeValue scrollTimeout;
    private final TriggeredWatch.Parser triggeredWatchParser;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final TimeValue defaultBulkTimeout;

    @Inject
    public TriggeredWatchStore(Settings settings, InternalClient client, TriggeredWatch.Parser triggeredWatchParser) {
        this(settings, new WatcherClientProxy(settings, client), triggeredWatchParser);
    }

    public TriggeredWatchStore(Settings settings, WatcherClientProxy client, TriggeredWatch.Parser triggeredWatchParser) {
        super(settings);
        this.scrollSize = settings.getAsInt("xpack.watcher.execution.scroll.size", Integer.valueOf(100));
        this.client = client;
        this.scrollTimeout = settings.getAsTime("xpack.watcher.execution.scroll.timeout", TimeValue.timeValueSeconds((long)30L));
        this.triggeredWatchParser = triggeredWatchParser;
        this.defaultBulkTimeout = settings.getAsTime("xpack.watcher.internal.ops.bulk.default_timeout", TimeValue.timeValueSeconds((long)120L));
    }

    public void start() {
        this.started.set(true);
    }

    public boolean validate(ClusterState state) {
        try {
            IndexMetaData indexMetaData = WatchStoreUtils.getConcreteIndex(INDEX_NAME, state.metaData());
            if (indexMetaData.getState() == IndexMetaData.State.CLOSE) {
                this.logger.debug("triggered watch index [{}] is marked as closed, watcher cannot be started", (Object)indexMetaData.getIndex().getName());
                return false;
            }
            return state.routingTable().index(indexMetaData.getIndex()).allPrimaryShardsActive();
        }
        catch (IndexNotFoundException e) {
            return true;
        }
        catch (IllegalStateException e) {
            this.logger.trace(() -> new ParameterizedMessage("error getting index meta data [{}]: ", (Object)INDEX_NAME), (Throwable)e);
            return false;
        }
    }

    public void stop() {
        this.started.set(false);
    }

    public void putAll(List<TriggeredWatch> triggeredWatches, ActionListener<BulkResponse> listener) throws IOException {
        if (triggeredWatches.isEmpty()) {
            listener.onResponse((Object)new BulkResponse(new BulkItemResponse[0], 0L));
            return;
        }
        this.ensureStarted();
        BulkRequest request = this.createBulkRequest(triggeredWatches, DOC_TYPE);
        this.client.bulk(request, (ActionListener<BulkResponse>)ActionListener.wrap(r -> {
            if (this.containsTypeMissingException((BulkResponse)r)) {
                this.client.bulk(this.createBulkRequest(triggeredWatches, LEGACY_DOC_TYPE), listener);
            } else {
                listener.onResponse(r);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public BulkResponse putAll(List<TriggeredWatch> triggeredWatches) throws IOException {
        PlainActionFuture future = PlainActionFuture.newFuture();
        this.putAll(triggeredWatches, (ActionListener<BulkResponse>)future);
        return (BulkResponse)future.actionGet(this.defaultBulkTimeout);
    }

    private boolean containsTypeMissingException(BulkResponse response) {
        return response.hasFailures() && Arrays.stream(response.getItems()).anyMatch(item -> item.isFailed() && ExceptionsHelper.unwrapCause((Throwable)item.getFailure().getCause()) instanceof TypeMissingException);
    }

    private BulkRequest createBulkRequest(List<TriggeredWatch> triggeredWatches, String docType) throws IOException {
        BulkRequest request = new BulkRequest();
        for (TriggeredWatch triggeredWatch : triggeredWatches) {
            IndexRequest indexRequest = new IndexRequest(INDEX_NAME, docType, triggeredWatch.id().value());
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                triggeredWatch.toXContent(builder, ToXContent.EMPTY_PARAMS);
                indexRequest.source(builder);
            }
            indexRequest.opType(DocWriteRequest.OpType.CREATE);
            request.add(indexRequest);
        }
        return request;
    }

    public void delete(Wid wid) {
        this.ensureStarted();
        DeleteResponse response = this.client.delete(new DeleteRequest(INDEX_NAME, DOC_TYPE, wid.value()));
        if (response.getResult() == DocWriteResponse.Result.NOT_FOUND) {
            this.client.delete(new DeleteRequest(INDEX_NAME, LEGACY_DOC_TYPE, wid.value()));
        }
        this.logger.trace("successfully deleted triggered watch with id [{}]", (Object)wid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<TriggeredWatch> loadTriggeredWatches(ClusterState state) {
        IndexMetaData indexMetaData;
        try {
            indexMetaData = WatchStoreUtils.getConcreteIndex(INDEX_NAME, state.metaData());
        }
        catch (IndexNotFoundException e) {
            return Collections.emptySet();
        }
        if (!state.routingTable().index(indexMetaData.getIndex()).allPrimaryShardsActive()) {
            throw Exceptions.illegalState("not all primary shards of the triggered watches index {} are started", indexMetaData.getIndex());
        }
        int numPrimaryShards = indexMetaData.getNumberOfShards();
        RefreshResponse refreshResponse = this.client.refresh(new RefreshRequest(new String[]{INDEX_NAME}));
        if (refreshResponse.getSuccessfulShards() < numPrimaryShards) {
            throw Exceptions.illegalState("refresh was supposed to run on [{}] shards, but ran on [{}] shards", numPrimaryShards, refreshResponse.getSuccessfulShards());
        }
        SearchRequest searchRequest = this.createScanSearchRequest();
        SearchResponse response = this.client.search(searchRequest, null);
        ArrayList<TriggeredWatch> triggeredWatches = new ArrayList<TriggeredWatch>();
        try {
            if (response.getTotalShards() != response.getSuccessfulShards()) {
                throw Exceptions.illegalState("scan search was supposed to run on [{}] shards, but ran on [{}] shards", numPrimaryShards, response.getSuccessfulShards());
            }
            while (response.getHits().getHits().length != 0) {
                for (SearchHit sh : response.getHits()) {
                    String id = sh.getId();
                    try {
                        TriggeredWatch triggeredWatch = this.triggeredWatchParser.parse(id, sh.getVersion(), sh.getSourceRef());
                        this.logger.trace("loaded triggered watch [{}/{}/{}]", (Object)sh.getIndex(), (Object)sh.getType(), (Object)sh.getId());
                        triggeredWatches.add(triggeredWatch);
                    }
                    catch (Exception e) {
                        this.logger.error(() -> new ParameterizedMessage("couldn't load triggered watch [{}], ignoring it...", (Object)id), (Throwable)e);
                    }
                }
                response = this.client.searchScroll(response.getScrollId(), this.scrollTimeout);
            }
        }
        finally {
            this.client.clearScroll(response.getScrollId());
        }
        this.logger.debug("loaded [{}] triggered watches", (Object)triggeredWatches.size());
        return triggeredWatches;
    }

    private SearchRequest createScanSearchRequest() {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().size(this.scrollSize).sort((SortBuilder)SortBuilders.fieldSort((String)"_doc"));
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME});
        searchRequest.source(sourceBuilder);
        searchRequest.scroll(this.scrollTimeout);
        searchRequest.preference("_primary");
        return searchRequest;
    }

    private void ensureStarted() {
        if (!this.started.get()) {
            throw Exceptions.illegalState("unable to persist triggered watches, the store is not ready", new Object[0]);
        }
    }
}

