/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.io.IOException;
import java.util.EnumSet;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class WatcherMetaData
extends AbstractNamedDiffable<MetaData.Custom>
implements MetaData.Custom {
    public static final String TYPE = "watcher";
    private final boolean manuallyStopped;

    public WatcherMetaData(boolean manuallyStopped) {
        this.manuallyStopped = manuallyStopped;
    }

    public boolean manuallyStopped() {
        return this.manuallyStopped;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public EnumSet<MetaData.XContentContext> context() {
        return EnumSet.of(MetaData.XContentContext.GATEWAY);
    }

    public WatcherMetaData(StreamInput streamInput) throws IOException {
        this(streamInput.readBoolean());
    }

    public static NamedDiff<MetaData.Custom> readDiffFrom(StreamInput streamInput) throws IOException {
        return WatcherMetaData.readDiffFrom(MetaData.Custom.class, (String)TYPE, (StreamInput)streamInput);
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeBoolean(this.manuallyStopped);
    }

    public static MetaData.Custom fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        Boolean manuallyStopped = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    currentFieldName = parser.currentName();
                    break;
                }
                case VALUE_BOOLEAN: {
                    if (!Field.MANUALLY_STOPPED.match(currentFieldName)) break;
                    manuallyStopped = parser.booleanValue();
                }
            }
        }
        if (manuallyStopped != null) {
            return new WatcherMetaData(manuallyStopped);
        }
        return null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Field.MANUALLY_STOPPED.getPreferredName(), this.manuallyStopped);
        return builder;
    }

    static interface Field {
        public static final ParseField MANUALLY_STOPPED = new ParseField("manually_stopped", new String[0]);
    }
}

