/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.watcher.WatcherMetaData;
import org.elasticsearch.xpack.watcher.WatcherService;
import org.elasticsearch.xpack.watcher.WatcherState;

public class WatcherLifeCycleService
extends AbstractComponent
implements ClusterStateApplier {
    private final ThreadPool threadPool;
    private final WatcherService watcherService;
    private final ClusterService clusterService;
    private volatile WatcherMetaData watcherMetaData;

    @Inject
    public WatcherLifeCycleService(Settings settings, ThreadPool threadPool, ClusterService clusterService, WatcherService watcherService) {
        super(settings);
        this.threadPool = threadPool;
        this.watcherService = watcherService;
        this.clusterService = clusterService;
        clusterService.addStateApplier((ClusterStateApplier)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                WatcherLifeCycleService.this.stop(false);
            }
        });
        this.watcherMetaData = new WatcherMetaData(settings.getAsBoolean("xpack.watcher.start_immediately", Boolean.valueOf(true)) == false);
    }

    public void start() {
        this.start(this.clusterService.state(), true);
    }

    public void stop() {
        this.stop(true);
    }

    private synchronized void stop(boolean manual) {
        WatcherState watcherState = this.watcherService.state();
        if (watcherState != WatcherState.STARTED) {
            this.logger.debug("not stopping watcher. watcher can only stop if its current state is [{}], but its current state now is [{}]", (Object)WatcherState.STARTED, (Object)watcherState);
        } else {
            this.watcherService.stop();
        }
        if (manual) {
            this.updateManualStopped(true);
        }
    }

    private synchronized void start(ClusterState state, boolean manual) {
        WatcherState watcherState = this.watcherService.state();
        if (watcherState != WatcherState.STOPPED) {
            this.logger.debug("not starting watcher. watcher can only start if its current state is [{}], but its current state now is [{}]", (Object)WatcherState.STOPPED, (Object)watcherState);
            return;
        }
        if (!manual && this.watcherMetaData.manuallyStopped()) {
            this.logger.debug("not starting watcher. watcher was stopped manually and therefore cannot be auto-started");
            return;
        }
        if (this.watcherService.validate(state)) {
            this.logger.trace("starting... (based on cluster state version [{}]) (manual [{}])", (Object)state.getVersion(), (Object)manual);
            try {
                this.watcherService.start(state);
            }
            catch (Exception e) {
                this.logger.warn("failed to start watcher. please wait for the cluster to become ready or try to start Watcher manually", (Throwable)e);
            }
        } else {
            this.logger.debug("not starting watcher. because the cluster isn't ready yet to run watcher");
        }
        if (manual) {
            this.updateManualStopped(false);
        }
    }

    public void applyClusterState(ClusterChangedEvent event) {
        block8: {
            block10: {
                boolean hasWatcherIndexBeenClosed;
                block9: {
                    block7: {
                        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
                            return;
                        }
                        WatcherMetaData watcherMetaData = (WatcherMetaData)event.state().getMetaData().custom("watcher");
                        if (watcherMetaData != null) {
                            this.watcherMetaData = watcherMetaData;
                        }
                        if (event.localNodeMaster()) break block7;
                        if (this.watcherService.state() == WatcherState.STARTED) {
                            this.threadPool.executor("generic").execute(() -> this.stop(false));
                        }
                        break block8;
                    }
                    if (this.watcherService.state() != WatcherState.STOPPED) break block9;
                    ClusterState state = event.state();
                    this.threadPool.executor("generic").execute(() -> this.start(state, false));
                    break block8;
                }
                boolean isWatchIndexDeleted = event.indicesDeleted().stream().anyMatch(index -> ".watches".equals(index.getName()));
                boolean isWatchIndexOpenInPreviousClusterState = event.previousState().metaData().hasIndex(".watches") && event.previousState().metaData().index(".watches").getState() == IndexMetaData.State.OPEN;
                boolean isWatchIndexClosedInCurrentClusterState = event.state().metaData().hasIndex(".watches") && event.state().metaData().index(".watches").getState() == IndexMetaData.State.CLOSE;
                boolean bl = hasWatcherIndexBeenClosed = isWatchIndexOpenInPreviousClusterState && isWatchIndexClosedInCurrentClusterState;
                if (isWatchIndexDeleted) break block10;
                if (!hasWatcherIndexBeenClosed) break block8;
            }
            this.threadPool.executor("generic").execute(this.watcherService::watchIndexDeletedOrClosed);
        }
    }

    public WatcherMetaData watcherMetaData() {
        return this.watcherMetaData;
    }

    private void updateManualStopped(final boolean stopped) {
        this.watcherMetaData = new WatcherMetaData(stopped);
        final CountDownLatch latch = new CountDownLatch(1);
        ActionListener<Boolean> listener = new ActionListener<Boolean>(){

            public void onResponse(Boolean aBoolean) {
                latch.countDown();
            }

            public void onFailure(Exception throwable) {
                WatcherLifeCycleService.this.logger.warn("updating manually stopped isn't acked", (Throwable)throwable);
                latch.countDown();
            }
        };
        AckedRequest request = new AckedRequest(){

            public TimeValue ackTimeout() {
                return TimeValue.timeValueSeconds((long)30L);
            }

            public TimeValue masterNodeTimeout() {
                return TimeValue.timeValueSeconds((long)30L);
            }
        };
        this.clusterService.submitStateUpdateTask("update_watcher_manually_stopped", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<Boolean>(request, (ActionListener)listener){

            protected Boolean newResponse(boolean result) {
                return result;
            }

            public ClusterState execute(ClusterState clusterState) throws Exception {
                ClusterState.Builder builder = new ClusterState.Builder(clusterState);
                builder.metaData(MetaData.builder((MetaData)clusterState.getMetaData()).putCustom("watcher", (MetaData.Custom)new WatcherMetaData(stopped)));
                return builder.build();
            }

            public void onFailure(String source, Exception throwable) {
                latch.countDown();
                WatcherLifeCycleService.this.logger.warn(() -> new ParameterizedMessage("couldn't update watcher metadata [{}]", (Object)source), (Throwable)throwable);
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

