/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.security.SecurityContext;
import org.elasticsearch.xpack.security.action.user.HasPrivilegesRequestBuilder;
import org.elasticsearch.xpack.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestHasPrivilegesAction
extends SecurityBaseRestHandler {
    private final SecurityContext securityContext;

    public RestHasPrivilegesAction(Settings settings, RestController controller, SecurityContext securityContext, XPackLicenseState licenseState) {
        super(settings, licenseState);
        this.securityContext = securityContext;
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/security/user/{username}/_has_privileges", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/user/{username}/_has_privileges", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/security/user/_has_privileges", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/user/_has_privileges", (RestHandler)this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String username = this.getUsername(request);
        HasPrivilegesRequestBuilder requestBuilder = new SecurityClient((ElasticsearchClient)client).prepareHasPrivileges(username, request.content(), request.getXContentType());
        return channel -> requestBuilder.execute((ActionListener)new HasPrivilegesRestResponseBuilder(username, (RestChannel)channel));
    }

    private String getUsername(RestRequest request) {
        String username = request.param("username");
        if (username != null) {
            return username;
        }
        return this.securityContext.getUser().principal();
    }

    static class HasPrivilegesRestResponseBuilder
    extends RestBuilderListener<HasPrivilegesResponse> {
        private String username;

        HasPrivilegesRestResponseBuilder(String username, RestChannel channel) {
            super(channel);
            this.username = username;
        }

        public RestResponse buildResponse(HasPrivilegesResponse response, XContentBuilder builder) throws Exception {
            builder.startObject().field("username", this.username).field("has_all_requested", response.isCompleteMatch());
            builder.field("cluster");
            builder.map(response.getClusterPrivileges());
            builder.startObject("index");
            for (HasPrivilegesResponse.IndexPrivileges index : response.getIndexPrivileges()) {
                builder.field(index.getIndex());
                builder.map(index.getPrivileges());
            }
            builder.endObject();
            builder.endObject();
            return new BytesRestResponse(RestStatus.OK, builder);
        }
    }
}

