/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.rolemapping;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.security.action.rolemapping.PutRoleMappingRequestBuilder;
import org.elasticsearch.xpack.security.action.rolemapping.PutRoleMappingResponse;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestPutRoleMappingAction
extends SecurityBaseRestHandler {
    public RestPutRoleMappingAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/role_mapping/{name}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_xpack/security/role_mapping/{name}", (RestHandler)this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String name = request.param("name");
        PutRoleMappingRequestBuilder requestBuilder = (PutRoleMappingRequestBuilder)new SecurityClient((ElasticsearchClient)client).preparePutRoleMapping(name, request.content(), request.getXContentType()).setRefreshPolicy(request.param("refresh"));
        return channel -> requestBuilder.execute((ActionListener)new RestBuilderListener<PutRoleMappingResponse>(channel){

            public RestResponse buildResponse(PutRoleMappingResponse response, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().field("role_mapping", (ToXContent)response).endObject());
            }
        });
    }
}

