/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.privilege;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.xpack.security.support.Automatons;

public class Privilege {
    public static final Privilege NONE = new Privilege(Collections.singleton("none"), Automatons.EMPTY);
    public static final Privilege ALL = new Privilege(Collections.singleton("all"), Automatons.MATCH_ALL);
    protected final Set<String> name;
    protected final Automaton automaton;
    protected final Predicate<String> predicate;

    public Privilege(String name, String ... patterns) {
        this(Collections.singleton(name), patterns);
    }

    public Privilege(Set<String> name, String ... patterns) {
        this(name, Automatons.patterns(patterns));
    }

    public Privilege(Set<String> name, Automaton automaton) {
        this.name = name;
        this.automaton = automaton;
        this.predicate = Automatons.predicate(automaton);
    }

    public Set<String> name() {
        return this.name;
    }

    public Predicate<String> predicate() {
        return this.predicate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Privilege privilege = (Privilege)o;
        return !(this.name != null ? !this.name.equals(privilege.name) : privilege.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    static String actionToPattern(String text) {
        return text + "*";
    }

    public String toString() {
        return this.name.toString();
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }
}

