/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.GetEntryLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ServerSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapMetaDataResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.ssl.SSLService;

abstract class PoolingSessionFactory
extends SessionFactory
implements Releasable {
    static final int DEFAULT_CONNECTION_POOL_SIZE = 20;
    static final int DEFAULT_CONNECTION_POOL_INITIAL_SIZE = 0;
    static final Setting<String> BIND_DN = Setting.simpleString((String)"bind_dn", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    static final Setting<String> BIND_PASSWORD = Setting.simpleString((String)"bind_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    private static final TimeValue DEFAULT_HEALTH_CHECK_INTERVAL = TimeValue.timeValueSeconds((long)60L);
    private static final Setting<Integer> POOL_INITIAL_SIZE = Setting.intSetting((String)"user_search.pool.initial_size", (int)0, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Integer> POOL_SIZE = Setting.intSetting((String)"user_search.pool.size", (int)20, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<TimeValue> HEALTH_CHECK_INTERVAL = Setting.timeSetting((String)"user_search.pool.health_check.interval", (TimeValue)DEFAULT_HEALTH_CHECK_INTERVAL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Boolean> HEALTH_CHECK_ENABLED = Setting.boolSetting((String)"user_search.pool.health_check.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Optional<String>> HEALTH_CHECK_DN = new Setting("user_search.pool.health_check.dn", (String)null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope});
    private final boolean useConnectionPool;
    private final LDAPConnectionPool connectionPool;
    final LdapMetaDataResolver metaDataResolver;
    final LdapSession.GroupsResolver groupResolver;

    PoolingSessionFactory(RealmConfig config, SSLService sslService, LdapSession.GroupsResolver groupResolver, Setting<Boolean> poolingEnabled, Supplier<BindRequest> bindRequestSupplier, Supplier<String> healthCheckDNSupplier) throws LDAPException {
        super(config, sslService);
        this.groupResolver = groupResolver;
        this.metaDataResolver = new LdapMetaDataResolver(config.settings(), this.ignoreReferralErrors);
        this.useConnectionPool = (Boolean)poolingEnabled.get(config.settings());
        this.connectionPool = this.useConnectionPool ? PoolingSessionFactory.createConnectionPool(config, this.serverSet, this.timeout, this.logger, bindRequestSupplier, healthCheckDNSupplier) : null;
    }

    @Override
    public final void session(String user, SecureString password, ActionListener<LdapSession> listener) {
        if (this.useConnectionPool) {
            this.getSessionWithPool(this.connectionPool, user, password, listener);
        } else {
            this.getSessionWithoutPool(user, password, listener);
        }
    }

    @Override
    public final void unauthenticatedSession(String user, ActionListener<LdapSession> listener) {
        if (this.useConnectionPool) {
            this.getUnauthenticatedSessionWithPool(this.connectionPool, user, listener);
        } else {
            this.getUnauthenticatedSessionWithoutPool(user, listener);
        }
    }

    abstract void getSessionWithPool(LDAPConnectionPool var1, String var2, SecureString var3, ActionListener<LdapSession> var4);

    abstract void getSessionWithoutPool(String var1, SecureString var2, ActionListener<LdapSession> var3);

    abstract void getUnauthenticatedSessionWithPool(LDAPConnectionPool var1, String var2, ActionListener<LdapSession> var3);

    abstract void getUnauthenticatedSessionWithoutPool(String var1, ActionListener<LdapSession> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LDAPConnectionPool createConnectionPool(RealmConfig config, ServerSet serverSet, TimeValue timeout, Logger logger, Supplier<BindRequest> bindRequestSupplier, Supplier<String> healthCheckDnSupplier) throws LDAPException {
        Settings settings = config.settings();
        BindRequest bindRequest = bindRequestSupplier.get();
        int initialSize = (Integer)POOL_INITIAL_SIZE.get(settings);
        int size = (Integer)POOL_SIZE.get(settings);
        LDAPConnectionPool pool = null;
        boolean success = false;
        try {
            pool = new LDAPConnectionPool(serverSet, bindRequest, initialSize, size);
            pool.setRetryFailedOperationsDueToInvalidConnections(true);
            if (((Boolean)HEALTH_CHECK_ENABLED.get(settings)).booleanValue()) {
                String entryDn = ((Optional)HEALTH_CHECK_DN.get(settings)).orElseGet(healthCheckDnSupplier);
                long healthCheckInterval = ((TimeValue)HEALTH_CHECK_INTERVAL.get(settings)).millis();
                if (entryDn != null) {
                    GetEntryLDAPConnectionPoolHealthCheck healthCheck = new GetEntryLDAPConnectionPoolHealthCheck(entryDn, timeout.millis(), false, false, false, true, false);
                    pool.setHealthCheck((LDAPConnectionPoolHealthCheck)healthCheck);
                    pool.setHealthCheckIntervalMillis(healthCheckInterval);
                } else {
                    logger.warn((Message)new ParameterizedMessage("[{}] and [{}} have not been specified or are not valid distinguished names,so connection health checking is disabled", (Object)RealmSettings.getFullSettingKey(config, BIND_DN), (Object)RealmSettings.getFullSettingKey(config, HEALTH_CHECK_DN)));
                }
            }
            success = true;
            LDAPConnectionPool lDAPConnectionPool = pool;
            return lDAPConnectionPool;
        }
        finally {
            if (!success && pool != null) {
                pool.close();
            }
        }
    }

    public final void close() {
        if (this.connectionPool != null) {
            this.connectionPool.close();
        }
    }

    public static Set<Setting<?>> getSettings() {
        return Sets.newHashSet((Object[])new Setting[]{POOL_INITIAL_SIZE, POOL_SIZE, HEALTH_CHECK_ENABLED, HEALTH_CHECK_INTERVAL, HEALTH_CHECK_DN, BIND_DN, BIND_PASSWORD});
    }
}

