/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityRequestControl;
import java.io.Closeable;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectoryGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.PoolingSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapMetaDataResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.CharArrays;
import org.elasticsearch.xpack.ssl.SSLService;

class ActiveDirectorySessionFactory
extends PoolingSessionFactory {
    static final String AD_DOMAIN_NAME_SETTING = "domain_name";
    static final String AD_GROUP_SEARCH_BASEDN_SETTING = "group_search.base_dn";
    static final String AD_GROUP_SEARCH_SCOPE_SETTING = "group_search.scope";
    static final String AD_USER_SEARCH_BASEDN_SETTING = "user_search.base_dn";
    static final String AD_USER_SEARCH_FILTER_SETTING = "user_search.filter";
    static final String AD_UPN_USER_SEARCH_FILTER_SETTING = "user_search.upn_filter";
    static final String AD_DOWN_LEVEL_USER_SEARCH_FILTER_SETTING = "user_search.down_level_filter";
    static final String AD_USER_SEARCH_SCOPE_SETTING = "user_search.scope";
    private static final String NETBIOS_NAME_FILTER_TEMPLATE = "(netbiosname={0})";
    private static final Setting<Boolean> POOL_ENABLED = Setting.boolSetting((String)"user_search.pool.enabled", settings -> Boolean.toString(PoolingSessionFactory.BIND_DN.exists(settings)), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    final DefaultADAuthenticator defaultADAuthenticator;
    final DownLevelADAuthenticator downLevelADAuthenticator;
    final UpnADAuthenticator upnADAuthenticator;

    ActiveDirectorySessionFactory(RealmConfig config, SSLService sslService) throws LDAPException {
        super(config, sslService, new ActiveDirectoryGroupsResolver(config.settings()), POOL_ENABLED, () -> {
            if (BIND_DN.exists(config.settings())) {
                return new SimpleBindRequest(ActiveDirectorySessionFactory.getBindDN(config.settings()), (String)BIND_PASSWORD.get(config.settings()));
            }
            return new SimpleBindRequest();
        }, () -> {
            String healthCheckDn;
            if (BIND_DN.exists(config.settings()) && (healthCheckDn = (String)BIND_DN.get(config.settings())).isEmpty() && healthCheckDn.indexOf(61) > 0) {
                return healthCheckDn;
            }
            return config.settings().get(AD_USER_SEARCH_BASEDN_SETTING, config.settings().get(AD_DOMAIN_NAME_SETTING));
        });
        Settings settings = config.settings();
        String domainName = settings.get(AD_DOMAIN_NAME_SETTING);
        if (domainName == null) {
            throw new IllegalArgumentException("missing [domain_name] setting for active directory");
        }
        String domainDN = ActiveDirectorySessionFactory.buildDnFromDomain(domainName);
        this.defaultADAuthenticator = new DefaultADAuthenticator(config, this.timeout, this.ignoreReferralErrors, this.logger, this.groupResolver, this.metaDataResolver, domainDN);
        this.downLevelADAuthenticator = new DownLevelADAuthenticator(config, this.timeout, this.ignoreReferralErrors, this.logger, this.groupResolver, this.metaDataResolver, domainDN, sslService);
        this.upnADAuthenticator = new UpnADAuthenticator(config, this.timeout, this.ignoreReferralErrors, this.logger, this.groupResolver, this.metaDataResolver, domainDN);
    }

    @Override
    protected String[] getDefaultLdapUrls(Settings settings) {
        return new String[]{"ldap://" + settings.get(AD_DOMAIN_NAME_SETTING) + ":389"};
    }

    @Override
    void getSessionWithPool(LDAPConnectionPool connectionPool, String user, SecureString password, ActionListener<LdapSession> listener) {
        this.getADAuthenticator(user).authenticate(connectionPool, user, password, listener);
    }

    @Override
    void getSessionWithoutPool(String username, SecureString password, ActionListener<LdapSession> listener) {
        Runnable runnable;
        try {
            LDAPConnection connection = this.serverSet.getConnection();
            runnable = () -> this.getADAuthenticator(username).authenticate(connection, username, password, (ActionListener<LdapSession>)ActionListener.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), e -> {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                listener.onFailure(e);
            }));
        }
        catch (LDAPException e) {
            runnable = () -> listener.onFailure((Exception)((Object)e));
        }
        runnable.run();
    }

    @Override
    void getUnauthenticatedSessionWithPool(LDAPConnectionPool connectionPool, String user, ActionListener<LdapSession> listener) {
        this.getADAuthenticator(user).searchForDN((LDAPInterface)connectionPool, user, null, Math.toIntExact(this.timeout.seconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null) {
                listener.onResponse(null);
            } else {
                String dn = entry.getDN();
                listener.onResponse((Object)new LdapSession(this.logger, this.config, (LDAPInterface)connectionPool, dn, this.groupResolver, this.metaDataResolver, this.timeout, null));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void getUnauthenticatedSessionWithoutPool(String user, ActionListener<LdapSession> listener) {
        if (BIND_DN.exists(this.config.settings())) {
            LDAPConnection connection = null;
            boolean startedSearching = false;
            try {
                connection = this.serverSet.getConnection();
                connection.bind((BindRequest)new SimpleBindRequest(ActiveDirectorySessionFactory.getBindDN(this.config.settings()), (String)BIND_PASSWORD.get(this.config.settings())));
                LDAPConnection finalConnection = connection;
                this.getADAuthenticator(user).searchForDN((LDAPInterface)finalConnection, user, null, Math.toIntExact(this.timeout.getSeconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                    if (entry == null) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{finalConnection});
                        listener.onResponse(null);
                    } else {
                        String dn = entry.getDN();
                        listener.onResponse((Object)new LdapSession(this.logger, this.config, (LDAPInterface)finalConnection, dn, this.groupResolver, this.metaDataResolver, this.timeout, null));
                    }
                }, e -> {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{finalConnection});
                    listener.onFailure(e);
                }));
                startedSearching = true;
                if (connection == null) return;
                if (startedSearching) return;
            }
            catch (LDAPException e2) {
                try {
                    listener.onFailure((Exception)((Object)e2));
                    if (connection == null || startedSearching) return;
                }
                catch (Throwable throwable) {
                    if (connection == null || startedSearching) throw throwable;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                return;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
            return;
        }
        listener.onResponse(null);
    }

    static String buildDnFromDomain(String domain) {
        return "DC=" + domain.replace(".", ",DC=");
    }

    static String getBindDN(Settings settings) {
        String bindDN = (String)BIND_DN.get(settings);
        if (!bindDN.isEmpty() && bindDN.indexOf(92) < 0 && bindDN.indexOf(64) < 0 && bindDN.indexOf(61) < 0) {
            bindDN = bindDN + "@" + settings.get(AD_DOMAIN_NAME_SETTING);
        }
        return bindDN;
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(SessionFactory.getSettings());
        settings.add(Setting.simpleString((String)AD_DOMAIN_NAME_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_GROUP_SEARCH_BASEDN_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_GROUP_SEARCH_SCOPE_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_USER_SEARCH_BASEDN_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_USER_SEARCH_FILTER_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_UPN_USER_SEARCH_FILTER_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_DOWN_LEVEL_USER_SEARCH_FILTER_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_USER_SEARCH_SCOPE_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.addAll(PoolingSessionFactory.getSettings());
        return settings;
    }

    ADAuthenticator getADAuthenticator(String username) {
        if (username.indexOf(92) > 0) {
            return this.downLevelADAuthenticator;
        }
        if (username.indexOf("@") > 0) {
            return this.upnADAuthenticator;
        }
        return this.defaultADAuthenticator;
    }

    static class UpnADAuthenticator
    extends ADAuthenticator {
        static final String UPN_USER_FILTER = "(&(objectClass=user)(userPrincipalName={1}))";

        UpnADAuthenticator(RealmConfig config, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, String domainDN) {
            super(config, timeout, ignoreReferralErrors, logger, groupsResolver, metaDataResolver, domainDN, ActiveDirectorySessionFactory.AD_UPN_USER_SEARCH_FILTER_SETTING, UPN_USER_FILTER);
            if (this.userSearchFilter.contains("{0}")) {
                new DeprecationLogger(logger).deprecated("The use of the account name variable {0} in the setting [" + RealmSettings.getFullSettingKey(config, ActiveDirectorySessionFactory.AD_UPN_USER_SEARCH_FILTER_SETTING) + "] has been deprecated and will be removed in a future version!", new Object[0]);
            }
        }

        @Override
        void searchForDN(LDAPInterface connection, String username, SecureString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            String[] parts = username.split("@");
            assert (parts.length == 2) : "there should have only been two values for " + username + " after splitting on '@'";
            String accountName = parts[0];
            try {
                Filter filter = LdapUtils.createFilter(this.userSearchFilter, accountName, username);
                LdapUtils.searchForEntry(connection, this.userSearchDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
            }
            catch (LDAPException e) {
                listener.onFailure((Exception)((Object)e));
            }
        }
    }

    static class DownLevelADAuthenticator
    extends ADAuthenticator {
        static final String DOWN_LEVEL_FILTER = "(&(objectClass=user)(sAMAccountName={0}))";
        Cache<String, String> domainNameCache = CacheBuilder.builder().setMaximumWeight(100L).build();
        final String domainDN;
        final Settings settings;
        final SSLService sslService;
        final RealmConfig config;

        DownLevelADAuthenticator(RealmConfig config, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, String domainDN, SSLService sslService) {
            super(config, timeout, ignoreReferralErrors, logger, groupsResolver, metaDataResolver, domainDN, ActiveDirectorySessionFactory.AD_DOWN_LEVEL_USER_SEARCH_FILTER_SETTING, DOWN_LEVEL_FILTER);
            this.domainDN = domainDN;
            this.settings = config.settings();
            this.sslService = sslService;
            this.config = config;
        }

        @Override
        void searchForDN(LDAPInterface connection, String username, SecureString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            String[] parts = username.split("\\\\");
            assert (parts.length == 2);
            String netBiosDomainName = parts[0];
            String accountName = parts[1];
            this.netBiosDomainNameToDn(connection, netBiosDomainName, username, password, timeLimitSeconds, (ActionListener<String>)ActionListener.wrap(domainDN -> {
                if (domainDN == null) {
                    listener.onResponse(null);
                } else {
                    try {
                        LdapUtils.searchForEntry(connection, domainDN, LdapSearchScope.SUB_TREE.scope(), LdapUtils.createFilter(this.userSearchFilter, accountName), timeLimitSeconds, this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
                    }
                    catch (LDAPException e) {
                        listener.onFailure((Exception)((Object)e));
                    }
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void netBiosDomainNameToDn(LDAPInterface ldapInterface, String netBiosDomainName, String username, SecureString password, int timeLimitSeconds, ActionListener<String> listener) {
            block9: {
                String cachedName = (String)this.domainNameCache.get((Object)netBiosDomainName);
                try {
                    if (cachedName != null) {
                        listener.onResponse((Object)cachedName);
                        break block9;
                    }
                    if (DownLevelADAuthenticator.usingGlobalCatalog(ldapInterface)) {
                        LDAPConnection ldapConnection;
                        block10: {
                            LDAPConnectionOptions options = ActiveDirectorySessionFactory.connectionOptions(this.config, this.sslService, this.logger);
                            boolean startedSearching = false;
                            LDAPConnection searchConnection = null;
                            ldapConnection = null;
                            try {
                                Filter filter = LdapUtils.createFilter(ActiveDirectorySessionFactory.NETBIOS_NAME_FILTER_TEMPLATE, netBiosDomainName);
                                ldapConnection = ldapInterface instanceof LDAPConnection ? (LDAPConnection)ldapInterface : ((LDAPConnectionPool)ldapInterface).getConnection();
                                LDAPConnection finalLdapConnection = ldapConnection;
                                searchConnection = new LDAPConnection(finalLdapConnection.getSocketFactory(), options, finalLdapConnection.getConnectedAddress(), finalLdapConnection.getSSLSession() != null ? 636 : 389);
                                SimpleBindRequest bindRequest = this.bindDN.isEmpty() ? new SimpleBindRequest(username, CharArrays.toUtf8Bytes(password.getChars())) : new SimpleBindRequest(this.bindDN, this.bindPassword);
                                searchConnection.bind((BindRequest)bindRequest);
                                LDAPConnection finalConnection = searchConnection;
                                LdapUtils.search(finalConnection, this.domainDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, this.ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(results -> {
                                    IOUtils.close((Closeable[])new Closeable[]{finalConnection});
                                    DownLevelADAuthenticator.handleSearchResults(results, netBiosDomainName, this.domainNameCache, listener);
                                }, e -> {
                                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{finalConnection});
                                    listener.onFailure(e);
                                }), "ncname");
                                startedSearching = true;
                                if (startedSearching) break block10;
                            }
                            catch (Throwable throwable) {
                                if (!startedSearching) {
                                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searchConnection});
                                }
                                if (ldapInterface instanceof LDAPConnectionPool && ldapConnection != null) {
                                    ((LDAPConnectionPool)ldapInterface).releaseConnection(ldapConnection);
                                }
                                throw throwable;
                            }
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searchConnection});
                        }
                        if (ldapInterface instanceof LDAPConnectionPool && ldapConnection != null) {
                            ((LDAPConnectionPool)ldapInterface).releaseConnection(ldapConnection);
                        }
                        break block9;
                    }
                    Filter filter = LdapUtils.createFilter(ActiveDirectorySessionFactory.NETBIOS_NAME_FILTER_TEMPLATE, netBiosDomainName);
                    LdapUtils.search(ldapInterface, this.domainDN, LdapSearchScope.SUB_TREE.scope(), filter, timeLimitSeconds, this.ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(results -> DownLevelADAuthenticator.handleSearchResults(results, netBiosDomainName, this.domainNameCache, listener), arg_0 -> listener.onFailure(arg_0)), "ncname");
                }
                catch (LDAPException e2) {
                    listener.onFailure((Exception)((Object)e2));
                }
            }
        }

        static void handleSearchResults(List<SearchResultEntry> results, String netBiosDomainName, Cache<String, String> domainNameCache, ActionListener<String> listener) {
            Optional<SearchResultEntry> entry = results.stream().filter(r -> r.hasAttribute("ncname")).findFirst();
            if (entry.isPresent()) {
                String value = entry.get().getAttributeValue("ncname");
                try {
                    domainNameCache.computeIfAbsent((Object)netBiosDomainName, s -> value);
                }
                catch (ExecutionException e) {
                    throw new AssertionError("failed to load constant non-null value", e);
                }
                listener.onResponse((Object)value);
            } else {
                listener.onResponse(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean usingGlobalCatalog(LDAPInterface ldap) throws LDAPException {
            if (ldap instanceof LDAPConnection) {
                return DownLevelADAuthenticator.usingGlobalCatalog((LDAPConnection)ldap);
            }
            LDAPConnectionPool pool = (LDAPConnectionPool)ldap;
            LDAPConnection connection = null;
            try {
                connection = pool.getConnection();
                boolean bl = DownLevelADAuthenticator.usingGlobalCatalog(connection);
                return bl;
            }
            finally {
                if (connection != null) {
                    pool.releaseConnection(connection);
                }
            }
        }

        private static boolean usingGlobalCatalog(LDAPConnection ldapConnection) {
            return ldapConnection.getConnectedPort() == 3268 || ldapConnection.getConnectedPort() == 3269;
        }
    }

    static class DefaultADAuthenticator
    extends ADAuthenticator {
        final String domainName;

        DefaultADAuthenticator(RealmConfig realm, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, String domainDN) {
            super(realm, timeout, ignoreReferralErrors, logger, groupsResolver, metaDataResolver, domainDN, ActiveDirectorySessionFactory.AD_USER_SEARCH_FILTER_SETTING, "(&(objectClass=user)(|(sAMAccountName={0})(userPrincipalName={0}@" + DefaultADAuthenticator.domainName(realm) + ")))");
            this.domainName = DefaultADAuthenticator.domainName(realm);
        }

        private static String domainName(RealmConfig realm) {
            return realm.settings().get(ActiveDirectorySessionFactory.AD_DOMAIN_NAME_SETTING);
        }

        @Override
        void searchForDN(LDAPInterface connection, String username, SecureString password, int timeLimitSeconds, ActionListener<SearchResultEntry> listener) {
            try {
                LdapUtils.searchForEntry(connection, this.userSearchDN, this.userSearchScope.scope(), LdapUtils.createFilter(this.userSearchFilter, username), timeLimitSeconds, this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupsResolver.attributes()));
            }
            catch (LDAPException e) {
                listener.onFailure((Exception)((Object)e));
            }
        }

        @Override
        String bindUsername(String username) {
            return username + "@" + this.domainName;
        }
    }

    static abstract class ADAuthenticator {
        private final RealmConfig realm;
        final TimeValue timeout;
        final boolean ignoreReferralErrors;
        final Logger logger;
        final LdapSession.GroupsResolver groupsResolver;
        final LdapMetaDataResolver metaDataResolver;
        final String userSearchDN;
        final LdapSearchScope userSearchScope;
        final String userSearchFilter;
        final String bindDN;
        final String bindPassword;

        ADAuthenticator(RealmConfig realm, TimeValue timeout, boolean ignoreReferralErrors, Logger logger, LdapSession.GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, String domainDN, String userSearchFilterSetting, String defaultUserSearchFilter) {
            this.realm = realm;
            this.timeout = timeout;
            this.ignoreReferralErrors = ignoreReferralErrors;
            this.logger = logger;
            this.groupsResolver = groupsResolver;
            this.metaDataResolver = metaDataResolver;
            Settings settings = realm.settings();
            this.bindDN = ActiveDirectorySessionFactory.getBindDN(settings);
            this.bindPassword = (String)PoolingSessionFactory.BIND_PASSWORD.get(settings);
            this.userSearchDN = settings.get(ActiveDirectorySessionFactory.AD_USER_SEARCH_BASEDN_SETTING, domainDN);
            this.userSearchScope = LdapSearchScope.resolve(settings.get(ActiveDirectorySessionFactory.AD_USER_SEARCH_SCOPE_SETTING), LdapSearchScope.SUB_TREE);
            this.userSearchFilter = settings.get(userSearchFilterSetting, defaultUserSearchFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void authenticate(LDAPConnection connection, String username, SecureString password, ActionListener<LdapSession> listener) {
            boolean success = false;
            try {
                connection.bind((BindRequest)new SimpleBindRequest(this.bindUsername(username), CharArrays.toUtf8Bytes(password.getChars()), new Control[]{new AuthorizationIdentityRequestControl()}));
                if (!this.bindDN.isEmpty()) {
                    connection.bind((BindRequest)new SimpleBindRequest(this.bindDN, this.bindPassword));
                }
                this.searchForDN((LDAPInterface)connection, username, password, Math.toIntExact(this.timeout.seconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                    if (entry == null) {
                        IOUtils.close((Closeable[])new Closeable[]{connection});
                        listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("search for user [" + username + "] by principle name yielded no results", new Object[0])));
                    } else {
                        String dn = entry.getDN();
                        listener.onResponse((Object)new LdapSession(this.logger, this.realm, (LDAPInterface)connection, dn, this.groupsResolver, this.metaDataResolver, this.timeout, null));
                    }
                }, e -> {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                    listener.onFailure(e);
                }));
                return;
            }
            catch (LDAPException e2) {
                try {
                    listener.onFailure((Exception)((Object)e2));
                    if (success) return;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                return;
            }
        }

        final void authenticate(LDAPConnectionPool pool, String username, SecureString password, ActionListener<LdapSession> listener) {
            try {
                SimpleBindRequest request = new SimpleBindRequest(this.bindUsername(username), CharArrays.toUtf8Bytes(password.getChars()));
                pool.bindAndRevertAuthentication((BindRequest)request);
                this.searchForDN((LDAPInterface)pool, username, password, Math.toIntExact(this.timeout.seconds()), (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                    if (entry == null) {
                        listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("search for user [" + username + "] by principle name yielded no results", new Object[0])));
                    } else {
                        String dn = entry.getDN();
                        listener.onResponse((Object)new LdapSession(this.logger, this.realm, (LDAPInterface)pool, dn, this.groupsResolver, this.metaDataResolver, this.timeout, null));
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            }
            catch (LDAPException e) {
                listener.onFailure((Exception)((Object)e));
            }
        }

        String bindUsername(String username) {
            return username;
        }

        final String getUserSearchFilter() {
            return this.userSearchFilter;
        }

        abstract void searchForDN(LDAPInterface var1, String var2, SecureString var3, int var4, ActionListener<SearchResultEntry> var5);
    }
}

