/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.InternalSecurityClient;
import org.elasticsearch.xpack.security.SecurityLifecycleService;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.ExpiredTokenRemover;
import org.elasticsearch.xpack.security.authc.UserToken;

public final class TokenService
extends AbstractComponent {
    private static final int ITERATIONS = 100000;
    private static final String KDF_ALGORITHM = "PBKDF2withHMACSHA512";
    private static final int SALT_BYTES = 32;
    private static final int IV_BYTES = 12;
    private static final int VERSION_BYTES = 4;
    private static final String ENCRYPTION_CIPHER = "AES/GCM/NoPadding";
    private static final String EXPIRED_TOKEN_WWW_AUTH_VALUE = "Bearer realm=\"security\", error=\"invalid_token\", error_description=\"The access token expired\"";
    private static final String MALFORMED_TOKEN_WWW_AUTH_VALUE = "Bearer realm=\"security\", error=\"invalid_token\", error_description=\"The access token is malformed\"";
    private static final String TYPE = "doc";
    public static final String INDEX_NAME = ".security";
    public static final String THREAD_POOL_NAME = "security-token-key";
    public static final Setting<SecureString> TOKEN_PASSPHRASE = SecureSetting.secureString((String)"xpack.security.authc.token.passphrase", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<TimeValue> TOKEN_EXPIRATION = Setting.timeSetting((String)"xpack.security.authc.token.timeout", (TimeValue)TimeValue.timeValueMinutes((long)20L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> DELETE_INTERVAL = Setting.timeSetting((String)"xpack.security.authc.token.delete.interval", (TimeValue)TimeValue.timeValueMinutes((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> DELETE_TIMEOUT = Setting.timeSetting((String)"xpack.security.authc.token.delete.timeout", (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final String DEFAULT_PASSPHRASE = "changeme is a terrible password, so let's not use it anymore!";
    static final String DOC_TYPE = "invalidated-token";
    static final int MINIMUM_BYTES = 49;
    static final int MINIMUM_BASE64_BYTES = Double.valueOf(Math.ceil(65.0)).intValue();
    private static final Version ACTIVE_KEY_HASH_VERSION = Version.fromString((String)"6.0.0-beta2");
    private final SecureRandom secureRandom = new SecureRandom();
    private final Cache<BytesKey, SecretKey> keyCache;
    private final SecureString tokenPassphrase;
    private final Clock clock;
    private final TimeValue expirationDelay;
    private final TimeValue deleteInterval;
    private final BytesKey salt;
    private final InternalSecurityClient internalClient;
    private final SecurityLifecycleService lifecycleService;
    private final ExpiredTokenRemover expiredTokenRemover;
    private final boolean enabled;
    private final byte[] currentVersionBytes;
    private volatile long lastExpirationRunMs;

    public TokenService(Settings settings, Clock clock, InternalSecurityClient internalClient, SecurityLifecycleService lifecycleService) throws GeneralSecurityException {
        super(settings);
        byte[] saltArr = new byte[32];
        this.secureRandom.nextBytes(saltArr);
        this.salt = new BytesKey(saltArr);
        this.keyCache = CacheBuilder.builder().setExpireAfterAccess(TimeValue.timeValueMinutes((long)60L)).setMaximumWeight(500L).build();
        SecureString tokenPassphraseValue = (SecureString)TOKEN_PASSPHRASE.get(settings);
        this.tokenPassphrase = tokenPassphraseValue.length() == 0 ? new SecureString(DEFAULT_PASSPHRASE.toCharArray()) : tokenPassphraseValue;
        this.clock = clock.withZone(ZoneOffset.UTC);
        this.expirationDelay = (TimeValue)TOKEN_EXPIRATION.get(settings);
        this.internalClient = internalClient;
        this.lifecycleService = lifecycleService;
        this.lastExpirationRunMs = internalClient.threadPool().relativeTimeInMillis();
        this.deleteInterval = (TimeValue)DELETE_INTERVAL.get(settings);
        this.enabled = (Boolean)XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.get(settings);
        this.expiredTokenRemover = new ExpiredTokenRemover(settings, internalClient);
        this.currentVersionBytes = ByteBuffer.allocate(4).putInt(Version.CURRENT.id).array();
        this.ensureEncryptionCiphersSupported();
        try (SecureString closeableChars = this.tokenPassphrase.clone();){
            this.keyCache.put((Object)this.salt, (Object)TokenService.computeSecretKey(closeableChars.getChars(), this.salt.bytes));
        }
    }

    public UserToken createUserToken(Authentication authentication) throws IOException, GeneralSecurityException {
        this.ensureEnabled();
        Instant expiration = this.getExpirationTime();
        return new UserToken(authentication, expiration);
    }

    void getAndValidateToken(ThreadContext ctx, ActionListener<UserToken> listener) {
        if (this.enabled) {
            String token = this.getFromHeader(ctx);
            if (token == null) {
                listener.onResponse(null);
            } else {
                try {
                    this.decodeToken(token, (ActionListener<UserToken>)ActionListener.wrap(userToken -> {
                        if (userToken != null) {
                            Instant currentTime = this.clock.instant();
                            if (currentTime.isAfter(userToken.getExpirationTime())) {
                                listener.onFailure((Exception)((Object)TokenService.expiredTokenException()));
                            } else {
                                this.checkIfTokenIsRevoked((UserToken)userToken, listener);
                            }
                        } else {
                            listener.onResponse(null);
                        }
                    }, arg_0 -> listener.onFailure(arg_0)));
                }
                catch (IOException e) {
                    this.logger.debug("invalid token", (Throwable)e);
                    listener.onResponse(null);
                }
            }
        } else {
            listener.onResponse(null);
        }
    }

    void decodeToken(String token, ActionListener<UserToken> listener) throws IOException {
        InputStreamStreamInput in = new InputStreamStreamInput(Base64.getDecoder().wrap(new ByteArrayInputStream(token.getBytes(StandardCharsets.UTF_8))));
        if (in.available() < MINIMUM_BASE64_BYTES) {
            this.logger.debug("invalid token");
            listener.onResponse(null);
        } else {
            Version version = Version.readVersion((StreamInput)in);
            if (version.before(Version.V_5_5_0)) {
                listener.onResponse(null);
            } else {
                BytesKey decodedSalt = new BytesKey(in.readByteArray());
                if (version.onOrAfter(ACTIVE_KEY_HASH_VERSION)) {
                    in.readByteArray();
                }
                SecretKey decodeKey = (SecretKey)this.keyCache.get((Object)decodedSalt);
                byte[] iv = in.readByteArray();
                if (decodeKey != null) {
                    try {
                        this.decryptToken((StreamInput)in, this.getDecryptionCipher(iv, decodeKey, version, decodedSalt), version, listener);
                    }
                    catch (GeneralSecurityException e) {
                        this.logger.debug("invalid token", (Throwable)e);
                        listener.onResponse(null);
                    }
                } else {
                    this.internalClient.threadPool().executor(THREAD_POOL_NAME).submit((Runnable)((Object)new KeyComputingRunnable((StreamInput)in, iv, version, decodedSalt, listener)));
                }
            }
        }
    }

    private void decryptToken(StreamInput in, Cipher cipher, Version version, ActionListener<UserToken> listener) throws IOException {
        try (CipherInputStream cis = new CipherInputStream((InputStream)in, cipher);
             InputStreamStreamInput decryptedInput = new InputStreamStreamInput((InputStream)cis);){
            decryptedInput.setVersion(version);
            listener.onResponse((Object)new UserToken((StreamInput)decryptedInput));
        }
    }

    public void invalidateToken(String tokenString, final ActionListener<Boolean> listener) {
        this.ensureEnabled();
        if (!this.lifecycleService.isSecurityIndexWriteable()) {
            listener.onFailure((Exception)new IllegalStateException("cannot write to the tokens index"));
        } else if (Strings.isNullOrEmpty((String)tokenString)) {
            listener.onFailure((Exception)new IllegalArgumentException("token must be provided"));
        } else {
            this.maybeStartTokenRemover();
            try {
                this.decodeToken(tokenString, (ActionListener<UserToken>)ActionListener.wrap(userToken -> {
                    if (userToken == null) {
                        listener.onFailure((Exception)((Object)TokenService.malformedTokenException()));
                    } else if (userToken.getExpirationTime().isBefore(this.clock.instant())) {
                        listener.onResponse((Object)false);
                    } else {
                        String id = TokenService.getDocumentId(userToken);
                        ((IndexRequestBuilder)this.internalClient.prepareIndex(INDEX_NAME, TYPE, id).setOpType(DocWriteRequest.OpType.CREATE).setSource(new Object[]{"doc_type", DOC_TYPE, "expiration_time", this.getExpirationTime().toEpochMilli()}).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL)).execute((ActionListener)new ActionListener<IndexResponse>(){

                            public void onResponse(IndexResponse indexResponse) {
                                listener.onResponse((Object)(indexResponse.getResult() == DocWriteResponse.Result.CREATED ? 1 : 0));
                            }

                            public void onFailure(Exception e) {
                                if (e instanceof VersionConflictEngineException) {
                                    listener.onResponse((Object)false);
                                } else {
                                    listener.onFailure(e);
                                }
                            }
                        });
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            }
            catch (IOException e) {
                this.logger.error("received a malformed token as part of a invalidation request", (Throwable)e);
                listener.onFailure((Exception)((Object)TokenService.malformedTokenException()));
            }
        }
    }

    private static String getDocumentId(UserToken userToken) {
        return "invalidated-token_" + userToken.getId();
    }

    private void ensureEnabled() {
        if (!this.enabled) {
            throw new IllegalStateException("tokens are not enabled");
        }
    }

    private void checkIfTokenIsRevoked(final UserToken userToken, final ActionListener<UserToken> listener) {
        if (this.lifecycleService.isSecurityIndexAvailable()) {
            this.internalClient.prepareGet(INDEX_NAME, TYPE, TokenService.getDocumentId(userToken)).execute((ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    if (response.isExists()) {
                        listener.onFailure((Exception)((Object)TokenService.expiredTokenException()));
                    } else {
                        listener.onResponse((Object)userToken);
                    }
                }

                public void onFailure(Exception e) {
                    if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                        TokenService.this.logger.warn("failed to get token [{}] since index is not available", (Object)userToken.getId());
                        listener.onResponse(null);
                    } else {
                        TokenService.this.logger.error((Message)new ParameterizedMessage("failed to get token [{}]", (Object)userToken.getId()), (Throwable)e);
                        listener.onFailure(e);
                    }
                }
            });
        } else if (this.lifecycleService.isSecurityIndexExisting()) {
            this.logger.warn("could not validate token as the security index is not available");
            listener.onResponse(null);
        } else {
            listener.onResponse((Object)userToken);
        }
    }

    public TimeValue getExpirationDelay() {
        return this.expirationDelay;
    }

    private Instant getExpirationTime() {
        return this.clock.instant().plusSeconds(this.expirationDelay.getSeconds());
    }

    private void maybeStartTokenRemover() {
        if (this.lifecycleService.isSecurityIndexAvailable() && this.internalClient.threadPool().relativeTimeInMillis() - this.lastExpirationRunMs > this.deleteInterval.getMillis()) {
            this.expiredTokenRemover.submit(this.internalClient.threadPool());
            this.lastExpirationRunMs = this.internalClient.threadPool().relativeTimeInMillis();
        }
    }

    private String getFromHeader(ThreadContext threadContext) {
        String header = threadContext.getHeader("Authorization");
        if (Strings.hasLength((String)header) && header.startsWith("Bearer ") && header.length() > "Bearer ".length()) {
            return header.substring("Bearer ".length());
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public String getUserTokenString(UserToken userToken) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void ensureEncryptionCiphersSupported() throws NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher.getInstance(ENCRYPTION_CIPHER);
        SecretKeyFactory.getInstance(KDF_ALGORITHM);
    }

    private Cipher getEncryptionCipher(byte[] iv) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(ENCRYPTION_CIPHER);
        cipher.init(1, (Key)this.keyCache.get((Object)this.salt), new GCMParameterSpec(128, iv), this.secureRandom);
        cipher.updateAAD(this.currentVersionBytes);
        cipher.updateAAD(this.salt.bytes);
        return cipher;
    }

    private Cipher getDecryptionCipher(byte[] iv, SecretKey key, Version version, BytesKey salt) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(ENCRYPTION_CIPHER);
        cipher.init(2, (Key)key, new GCMParameterSpec(128, iv), this.secureRandom);
        cipher.updateAAD(ByteBuffer.allocate(4).putInt(version.id).array());
        cipher.updateAAD(salt.bytes);
        return cipher;
    }

    private byte[] getNewInitializationVector() {
        byte[] initializationVector = new byte[12];
        this.secureRandom.nextBytes(initializationVector);
        return initializationVector;
    }

    static SecretKey computeSecretKey(char[] rawPassword, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(KDF_ALGORITHM);
        PBEKeySpec keySpec = new PBEKeySpec(rawPassword, salt, 100000, 128);
        SecretKey tmp = secretKeyFactory.generateSecret(keySpec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }

    private static ElasticsearchSecurityException expiredTokenException() {
        ElasticsearchSecurityException e = new ElasticsearchSecurityException("token expired", RestStatus.UNAUTHORIZED, new Object[0]);
        e.addHeader("WWW-Authenticate", new String[]{EXPIRED_TOKEN_WWW_AUTH_VALUE});
        return e;
    }

    private static ElasticsearchSecurityException malformedTokenException() {
        ElasticsearchSecurityException e = new ElasticsearchSecurityException("token malformed", RestStatus.UNAUTHORIZED, new Object[0]);
        e.addHeader("WWW-Authenticate", new String[]{MALFORMED_TOKEN_WWW_AUTH_VALUE});
        return e;
    }

    boolean isExpiredTokenException(ElasticsearchSecurityException e) {
        List headers = e.getHeader("WWW-Authenticate");
        return headers != null && headers.stream().anyMatch(EXPIRED_TOKEN_WWW_AUTH_VALUE::equals);
    }

    boolean isExpirationInProgress() {
        return this.expiredTokenRemover.isExpirationInProgress();
    }

    static class BytesKey {
        final byte[] bytes;
        private final int hashCode;

        BytesKey(byte[] bytes) {
            this.bytes = bytes;
            this.hashCode = StringHelper.murmurhash3_x86_32((byte[])bytes, (int)0, (int)bytes.length, (int)StringHelper.GOOD_FAST_HASH_SEED);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof BytesKey)) {
                return false;
            }
            BytesKey otherBytes = (BytesKey)other;
            return Arrays.equals(otherBytes.bytes, this.bytes);
        }
    }

    private class KeyComputingRunnable
    extends AbstractRunnable {
        private final StreamInput in;
        private final Version version;
        private final BytesKey decodedSalt;
        private final ActionListener<UserToken> listener;
        private final byte[] iv;

        KeyComputingRunnable(StreamInput input, byte[] iv, Version version, BytesKey decodedSalt, ActionListener<UserToken> listener) {
            this.in = input;
            this.version = version;
            this.decodedSalt = decodedSalt;
            this.listener = listener;
            this.iv = iv;
        }

        protected void doRun() {
            try {
                SecretKey computedKey = (SecretKey)TokenService.this.keyCache.computeIfAbsent((Object)this.decodedSalt, salt -> {
                    try (SecureString closeableChars = TokenService.this.tokenPassphrase.clone();){
                        SecretKey secretKey = TokenService.computeSecretKey(closeableChars.getChars(), this.decodedSalt.bytes);
                        return secretKey;
                    }
                });
                TokenService.this.decryptToken(this.in, TokenService.this.getDecryptionCipher(this.iv, computedKey, this.version, this.decodedSalt), this.version, (ActionListener<UserToken>)this.listener);
            }
            catch (ExecutionException e) {
                if (e.getCause() != null && (e.getCause() instanceof GeneralSecurityException || e.getCause() instanceof IOException || e.getCause() instanceof IllegalArgumentException)) {
                    TokenService.this.logger.debug("unable to decode bearer token", (Throwable)e);
                    this.listener.onResponse(null);
                } else {
                    this.listener.onFailure((Exception)e);
                }
            }
            catch (IOException | GeneralSecurityException e) {
                TokenService.this.logger.debug("unable to decode bearer token", (Throwable)e);
                this.listener.onResponse(null);
            }
        }

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }

        public void onAfter() {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.in});
        }
    }
}

