/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.token;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.security.action.token.CreateTokenRequest;
import org.elasticsearch.xpack.security.action.token.CreateTokenResponse;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.UserToken;

public final class TransportCreateTokenAction
extends HandledTransportAction<CreateTokenRequest, CreateTokenResponse> {
    private static final String DEFAULT_SCOPE = "full";
    private final TokenService tokenService;
    private final AuthenticationService authenticationService;

    @Inject
    public TransportCreateTokenAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TokenService tokenService, AuthenticationService authenticationService) {
        super(settings, "cluster:admin/xpack/security/token/create", threadPool, transportService, actionFilters, indexNameExpressionResolver, CreateTokenRequest::new);
        this.tokenService = tokenService;
        this.authenticationService = authenticationService;
    }

    protected void doExecute(CreateTokenRequest request, ActionListener<CreateTokenResponse> listener) {
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
            this.authenticationService.authenticate("cluster:admin/xpack/security/token/create", (TransportMessage)request, request.getUsername(), request.getPassword(), (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                try (SecureString ignore1 = request.getPassword();){
                    UserToken token = this.tokenService.createUserToken((Authentication)authentication);
                    String tokenStr = this.tokenService.getUserTokenString(token);
                    String scope = request.getScope() != null ? DEFAULT_SCOPE : null;
                    listener.onResponse((Object)new CreateTokenResponse(tokenStr, this.tokenService.getExpirationDelay(), scope));
                }
            }, e -> {
                request.getPassword().close();
                listener.onFailure(e);
            }));
        }
    }
}

