/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.token;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class InvalidateTokenRequest
extends ActionRequest {
    private String tokenString;

    InvalidateTokenRequest() {
    }

    public InvalidateTokenRequest(String tokenString) {
        this.tokenString = tokenString;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.tokenString)) {
            validationException = ValidateActions.addValidationError((String)"token string must be provided", null);
        }
        return validationException;
    }

    String getTokenString() {
        return this.tokenString;
    }

    void setTokenString(String token) {
        this.tokenString = token;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.tokenString);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.tokenString = in.readString();
    }
}

