/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;

public class BackwardsCompatibilityAliasesResource
extends HttpResource {
    private static final Logger logger = Loggers.getLogger(BackwardsCompatibilityAliasesResource.class);
    private final TimeValue masterTimeout;

    public BackwardsCompatibilityAliasesResource(String resourceOwnerName, @Nullable TimeValue masterTimeout) {
        super(resourceOwnerName);
        this.masterTimeout = masterTimeout;
    }

    @Override
    protected boolean doCheckAndPublish(RestClient client) {
        XContentBuilder request;
        boolean needNewAliases = false;
        try {
            Response response = client.performRequest("GET", "/.marvel-es-1-*", Collections.singletonMap("filter_path", "*.aliases"), new Header[0]);
            Map indices = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (InputStream)response.getEntity().getContent(), (boolean)false);
            request = JsonXContent.contentBuilder();
            request.startObject().startArray("actions");
            for (Map.Entry e : indices.entrySet()) {
                String index = (String)e.getKey();
                String alias = ".monitoring-es-2-" + index.substring(".marvel-es-1-".length()) + "-alias";
                if (this.aliasesForIndex(e.getValue()).contains(alias)) continue;
                needNewAliases = true;
                this.addAlias(request, index, alias);
            }
            request.endArray().endObject();
        }
        catch (ResponseException e) {
            int statusCode = e.getResponse().getStatusLine().getStatusCode();
            if (statusCode == RestStatus.NOT_FOUND.getStatus()) {
                logger.debug("no 2.x monitoring indexes found so no need to create backwards compatibility aliases");
                return true;
            }
            logger.error(() -> new ParameterizedMessage("failed to check for 2.x monitoring indexes with [{}]", (Object)statusCode), (Throwable)e);
            return false;
        }
        catch (IOException | RuntimeException e) {
            logger.error("failed to check for 2.x monitoring indexes", (Throwable)e);
            return false;
        }
        if (!needNewAliases) {
            return true;
        }
        try {
            BytesRef bytes = request.bytes().toBytesRef();
            ByteArrayEntity body = new ByteArrayEntity(bytes.bytes, bytes.offset, bytes.length, ContentType.APPLICATION_JSON);
            Response response = client.performRequest("POST", "/_aliases", this.parameters(), (HttpEntity)body, new Header[0]);
            Map aliasesResponse = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (InputStream)response.getEntity().getContent(), (boolean)false);
            Boolean acked = (Boolean)aliasesResponse.get("acknowledged");
            if (acked == null) {
                logger.error("Unexpected response format from _aliases action {}", (Object)aliasesResponse);
                return false;
            }
            return acked;
        }
        catch (IOException | RuntimeException e) {
            logger.error("failed to create aliases for 2.x monitoring indexes", (Throwable)e);
            return false;
        }
    }

    private Set<?> aliasesForIndex(Object indexInfo) {
        Map info = (Map)indexInfo;
        Map aliases = (Map)info.get("aliases");
        return aliases.keySet();
    }

    Map<String, String> parameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.masterTimeout != null) {
            parameters.put("master_timeout", this.masterTimeout.getStringRep());
        }
        return parameters;
    }

    private void addAlias(XContentBuilder request, String index, String alias) throws IOException {
        request.startObject().startObject("add");
        request.field("index", index);
        request.field("alias", alias);
        request.endObject().endObject();
    }
}

