/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.shards;

import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class ShardMonitoringDoc
extends MonitoringDoc {
    public static final String TYPE = "shards";
    private ShardRouting shardRouting;
    private String clusterStateUUID;

    public ShardMonitoringDoc(String monitoringId, String monitoringVersion, String clusterUUID, long timestamp, DiscoveryNode node, ShardRouting shardRouting, String clusterStateUUID) {
        super(monitoringId, monitoringVersion, TYPE, ShardMonitoringDoc.id(clusterStateUUID, shardRouting), clusterUUID, timestamp, node);
        this.shardRouting = shardRouting;
        this.clusterStateUUID = clusterStateUUID;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public String getClusterStateUUID() {
        return this.clusterStateUUID;
    }

    public static String id(String stateUUID, ShardRouting shardRouting) {
        StringBuilder builder = new StringBuilder();
        builder.append(stateUUID);
        builder.append(':');
        if (shardRouting.assignedToNode()) {
            builder.append(shardRouting.currentNodeId());
        } else {
            builder.append("_na");
        }
        builder.append(':');
        builder.append(shardRouting.getIndexName());
        builder.append(':');
        builder.append((Object)shardRouting.id());
        builder.append(':');
        if (shardRouting.primary()) {
            builder.append("p");
        } else {
            builder.append("r");
        }
        return builder.toString();
    }
}

