/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.XPackPlugin;

public class MonitoringSettings
extends AbstractComponent {
    public static final String LEGACY_DATA_INDEX_NAME = ".marvel-es-data";
    public static final String HISTORY_DURATION_SETTING_NAME = "history.duration";
    public static final TimeValue HISTORY_DURATION_MINIMUM = TimeValue.timeValueHours((long)24L);
    static final TimeValue MIN_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    public static final Setting<TimeValue> INTERVAL = new Setting(MonitoringSettings.collectionKey("interval"), "10s", s -> {
        TimeValue value = TimeValue.parseTimeValue((String)s, null, (String)MonitoringSettings.collectionKey("interval"));
        if (TimeValue.MINUS_ONE.equals((Object)value) || value.millis() >= MIN_INTERVAL.millis()) {
            return value;
        }
        throw new IllegalArgumentException("Failed to parse monitoring interval [" + s + "], value must be >= " + MIN_INTERVAL);
    }, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> INDEX_STATS_TIMEOUT = Setting.timeSetting((String)MonitoringSettings.collectionKey("index.stats.timeout"), (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<List<String>> INDICES = Setting.listSetting((String)MonitoringSettings.collectionKey("indices"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> CLUSTER_STATE_TIMEOUT = Setting.timeSetting((String)MonitoringSettings.collectionKey("cluster.state.timeout"), (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> CLUSTER_STATS_TIMEOUT = Setting.timeSetting((String)MonitoringSettings.collectionKey("cluster.stats.timeout"), (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> JOB_STATS_TIMEOUT = Setting.timeSetting((String)MonitoringSettings.collectionKey("ml.job.stats.timeout"), (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> INDEX_RECOVERY_TIMEOUT = Setting.timeSetting((String)MonitoringSettings.collectionKey("index.recovery.timeout"), (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> INDEX_RECOVERY_ACTIVE_ONLY = Setting.boolSetting((String)MonitoringSettings.collectionKey("index.recovery.active_only"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> HISTORY_DURATION = Setting.timeSetting((String)MonitoringSettings.key("history.duration"), (TimeValue)TimeValue.timeValueHours((long)168L), (TimeValue)HISTORY_DURATION_MINIMUM, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Settings> EXPORTERS_SETTINGS = Setting.groupSetting((String)MonitoringSettings.key("exporters."), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile TimeValue indexStatsTimeout;
    private volatile TimeValue clusterStateTimeout;
    private volatile TimeValue clusterStatsTimeout;
    private volatile TimeValue recoveryTimeout;
    private volatile TimeValue jobStatsTimeout;
    private volatile boolean recoveryActiveOnly;
    private volatile String[] indices;

    public static List<Setting<?>> getSettings() {
        return Arrays.asList(INDICES, INTERVAL, INDEX_RECOVERY_TIMEOUT, INDEX_STATS_TIMEOUT, INDEX_RECOVERY_ACTIVE_ONLY, CLUSTER_STATE_TIMEOUT, CLUSTER_STATS_TIMEOUT, JOB_STATS_TIMEOUT, HISTORY_DURATION, EXPORTERS_SETTINGS);
    }

    public static List<String> getSettingsFilter() {
        return Arrays.asList(MonitoringSettings.key("exporters.*.auth.*"), MonitoringSettings.key("exporters.*.ssl.*"));
    }

    public MonitoringSettings(Settings settings, ClusterSettings clusterSettings) {
        super(settings);
        this.setIndexStatsTimeout((TimeValue)INDEX_STATS_TIMEOUT.get(settings));
        clusterSettings.addSettingsUpdateConsumer(INDEX_STATS_TIMEOUT, this::setIndexStatsTimeout);
        this.setIndices((List)INDICES.get(settings));
        clusterSettings.addSettingsUpdateConsumer(INDICES, this::setIndices);
        this.setClusterStateTimeout((TimeValue)CLUSTER_STATE_TIMEOUT.get(settings));
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_STATE_TIMEOUT, this::setClusterStateTimeout);
        this.setClusterStatsTimeout((TimeValue)CLUSTER_STATS_TIMEOUT.get(settings));
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_STATS_TIMEOUT, this::setClusterStatsTimeout);
        this.setJobStatsTimeout((TimeValue)JOB_STATS_TIMEOUT.get(settings));
        clusterSettings.addSettingsUpdateConsumer(JOB_STATS_TIMEOUT, this::setJobStatsTimeout);
        this.setRecoveryTimeout((TimeValue)INDEX_RECOVERY_TIMEOUT.get(settings));
        clusterSettings.addSettingsUpdateConsumer(INDEX_RECOVERY_TIMEOUT, this::setRecoveryTimeout);
        this.setRecoveryActiveOnly((Boolean)INDEX_RECOVERY_ACTIVE_ONLY.get(settings));
        clusterSettings.addSettingsUpdateConsumer(INDEX_RECOVERY_ACTIVE_ONLY, this::setRecoveryActiveOnly);
    }

    public TimeValue indexStatsTimeout() {
        return this.indexStatsTimeout;
    }

    public String[] indices() {
        return this.indices;
    }

    public TimeValue clusterStateTimeout() {
        return this.clusterStateTimeout;
    }

    public TimeValue clusterStatsTimeout() {
        return this.clusterStatsTimeout;
    }

    public TimeValue jobStatsTimeout() {
        return this.jobStatsTimeout;
    }

    public TimeValue recoveryTimeout() {
        return this.recoveryTimeout;
    }

    public boolean recoveryActiveOnly() {
        return this.recoveryActiveOnly;
    }

    private void setIndexStatsTimeout(TimeValue indexStatsTimeout) {
        this.indexStatsTimeout = indexStatsTimeout;
    }

    private void setClusterStateTimeout(TimeValue clusterStateTimeout) {
        this.clusterStateTimeout = clusterStateTimeout;
    }

    private void setClusterStatsTimeout(TimeValue clusterStatsTimeout) {
        this.clusterStatsTimeout = clusterStatsTimeout;
    }

    private void setJobStatsTimeout(TimeValue jobStatsTimeout) {
        this.jobStatsTimeout = jobStatsTimeout;
    }

    private void setRecoveryTimeout(TimeValue recoveryTimeout) {
        this.recoveryTimeout = recoveryTimeout;
    }

    private void setRecoveryActiveOnly(boolean recoveryActiveOnly) {
        this.recoveryActiveOnly = recoveryActiveOnly;
    }

    private void setIndices(List<String> indices) {
        this.indices = indices.toArray(new String[0]);
    }

    static String collectionKey(String key) {
        return MonitoringSettings.key("collection." + key);
    }

    static String key(String key) {
        return XPackPlugin.featureSettingPrefix("monitoring") + "." + key;
    }
}

