/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.datafeeds;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;

public class RestGetDatafeedStatsAction
extends BaseRestHandler {
    public RestGetDatafeedStatsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/ml/datafeeds/{" + DatafeedConfig.ID.getPreferredName() + "}/_stats", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/ml/datafeeds/_stats", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String datafeedId = restRequest.param(DatafeedConfig.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)datafeedId)) {
            datafeedId = "_all";
        }
        GetDatafeedsStatsAction.Request request = new GetDatafeedsStatsAction.Request(datafeedId);
        return channel -> client.execute((Action)GetDatafeedsStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

