/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.results;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.FlushAcknowledgement;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.ml.job.results.Influencer;
import org.elasticsearch.xpack.ml.job.results.ModelPlot;

public class AutodetectResult
extends ToXContentToBytes
implements Writeable {
    public static final ParseField TYPE = new ParseField("autodetect_result", new String[0]);
    public static final ConstructingObjectParser<AutodetectResult, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), a -> new AutodetectResult((Bucket)((Object)((Object)a[0])), (List)a[1], (List)a[2], (Quantiles)((Object)((Object)a[3])), a[4] == null ? null : ((ModelSnapshot.Builder)a[4]).build(), a[5] == null ? null : ((ModelSizeStats.Builder)a[5]).build(), (ModelPlot)((Object)((Object)a[6])), (CategoryDefinition)((Object)((Object)a[7])), (FlushAcknowledgement)((Object)((Object)a[8]))));
    private final Bucket bucket;
    private final List<AnomalyRecord> records;
    private final List<Influencer> influencers;
    private final Quantiles quantiles;
    private final ModelSnapshot modelSnapshot;
    private final ModelSizeStats modelSizeStats;
    private final ModelPlot modelPlot;
    private final CategoryDefinition categoryDefinition;
    private final FlushAcknowledgement flushAcknowledgement;

    public AutodetectResult(Bucket bucket, List<AnomalyRecord> records, List<Influencer> influencers, Quantiles quantiles, ModelSnapshot modelSnapshot, ModelSizeStats modelSizeStats, ModelPlot modelPlot, CategoryDefinition categoryDefinition, FlushAcknowledgement flushAcknowledgement) {
        this.bucket = bucket;
        this.records = records;
        this.influencers = influencers;
        this.quantiles = quantiles;
        this.modelSnapshot = modelSnapshot;
        this.modelSizeStats = modelSizeStats;
        this.modelPlot = modelPlot;
        this.categoryDefinition = categoryDefinition;
        this.flushAcknowledgement = flushAcknowledgement;
    }

    public AutodetectResult(StreamInput in) throws IOException {
        this.bucket = in.readBoolean() ? new Bucket(in) : null;
        this.records = in.readBoolean() ? in.readList(AnomalyRecord::new) : null;
        this.influencers = in.readBoolean() ? in.readList(Influencer::new) : null;
        this.quantiles = in.readBoolean() ? new Quantiles(in) : null;
        this.modelSnapshot = in.readBoolean() ? new ModelSnapshot(in) : null;
        this.modelSizeStats = in.readBoolean() ? new ModelSizeStats(in) : null;
        this.modelPlot = in.readBoolean() ? new ModelPlot(in) : null;
        this.categoryDefinition = in.readBoolean() ? new CategoryDefinition(in) : null;
        this.flushAcknowledgement = in.readBoolean() ? new FlushAcknowledgement(in) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        AutodetectResult.writeNullable(this.bucket, out);
        AutodetectResult.writeNullable(this.records, out);
        AutodetectResult.writeNullable(this.influencers, out);
        AutodetectResult.writeNullable(this.quantiles, out);
        AutodetectResult.writeNullable(this.modelSnapshot, out);
        AutodetectResult.writeNullable(this.modelSizeStats, out);
        AutodetectResult.writeNullable(this.modelPlot, out);
        AutodetectResult.writeNullable(this.categoryDefinition, out);
        AutodetectResult.writeNullable(this.flushAcknowledgement, out);
    }

    private static void writeNullable(Writeable writeable, StreamOutput out) throws IOException {
        boolean isPresent = writeable != null;
        out.writeBoolean(isPresent);
        if (isPresent) {
            writeable.writeTo(out);
        }
    }

    private static void writeNullable(List<? extends Writeable> writeables, StreamOutput out) throws IOException {
        boolean isPresent = writeables != null;
        out.writeBoolean(isPresent);
        if (isPresent) {
            out.writeList(writeables);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        AutodetectResult.addNullableField(Bucket.RESULT_TYPE_FIELD, (ToXContent)this.bucket, builder);
        AutodetectResult.addNullableField(AnomalyRecord.RESULTS_FIELD, this.records, builder);
        AutodetectResult.addNullableField(Influencer.RESULTS_FIELD, this.influencers, builder);
        AutodetectResult.addNullableField(Quantiles.TYPE, (ToXContent)this.quantiles, builder);
        AutodetectResult.addNullableField(ModelSnapshot.TYPE, (ToXContent)this.modelSnapshot, builder);
        AutodetectResult.addNullableField(ModelSizeStats.RESULT_TYPE_FIELD, (ToXContent)this.modelSizeStats, builder);
        AutodetectResult.addNullableField(ModelPlot.RESULTS_FIELD, (ToXContent)this.modelPlot, builder);
        AutodetectResult.addNullableField(CategoryDefinition.TYPE, (ToXContent)this.categoryDefinition, builder);
        AutodetectResult.addNullableField(FlushAcknowledgement.TYPE, (ToXContent)this.flushAcknowledgement, builder);
        builder.endObject();
        return builder;
    }

    private static void addNullableField(ParseField field, ToXContent value, XContentBuilder builder) throws IOException {
        if (value != null) {
            builder.field(field.getPreferredName(), value);
        }
    }

    private static void addNullableField(ParseField field, List<? extends ToXContent> values, XContentBuilder builder) throws IOException {
        if (values != null) {
            builder.field(field.getPreferredName(), values);
        }
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public List<AnomalyRecord> getRecords() {
        return this.records;
    }

    public List<Influencer> getInfluencers() {
        return this.influencers;
    }

    public Quantiles getQuantiles() {
        return this.quantiles;
    }

    public ModelSnapshot getModelSnapshot() {
        return this.modelSnapshot;
    }

    public ModelSizeStats getModelSizeStats() {
        return this.modelSizeStats;
    }

    public ModelPlot getModelPlot() {
        return this.modelPlot;
    }

    public CategoryDefinition getCategoryDefinition() {
        return this.categoryDefinition;
    }

    public FlushAcknowledgement getFlushAcknowledgement() {
        return this.flushAcknowledgement;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bucket, this.records, this.influencers, this.categoryDefinition, this.flushAcknowledgement, this.modelPlot, this.modelSizeStats, this.modelSnapshot, this.quantiles});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AutodetectResult other = (AutodetectResult)((Object)obj);
        return Objects.equals((Object)this.bucket, (Object)other.bucket) && Objects.equals(this.records, other.records) && Objects.equals(this.influencers, other.influencers) && Objects.equals((Object)this.categoryDefinition, (Object)other.categoryDefinition) && Objects.equals((Object)this.flushAcknowledgement, (Object)other.flushAcknowledgement) && Objects.equals((Object)this.modelPlot, (Object)other.modelPlot) && Objects.equals((Object)this.modelSizeStats, (Object)other.modelSizeStats) && Objects.equals((Object)this.modelSnapshot, (Object)other.modelSnapshot) && Objects.equals((Object)this.quantiles, (Object)other.quantiles);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), Bucket.PARSER, Bucket.RESULT_TYPE_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), AnomalyRecord.PARSER, AnomalyRecord.RESULTS_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), Influencer.PARSER, Influencer.RESULTS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), Quantiles.PARSER, Quantiles.TYPE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ModelSnapshot.PARSER, ModelSnapshot.TYPE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ModelSizeStats.PARSER, ModelSizeStats.RESULT_TYPE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ModelPlot.PARSER, ModelPlot.RESULTS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), CategoryDefinition.PARSER, CategoryDefinition.TYPE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), FlushAcknowledgement.PARSER, FlushAcknowledgement.TYPE);
    }
}

