/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.xpack.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.ml.job.persistence.StateStreamer;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.FlushAcknowledgement;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.DataLoadParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.FlushJobParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.results.AutodetectResult;

public class BlackHoleAutodetectProcess
implements AutodetectProcess {
    private static final String FLUSH_ID = "flush-1";
    private final String jobId;
    private final ZonedDateTime startTime;
    private final BlockingQueue<AutodetectResult> results = new LinkedBlockingDeque<AutodetectResult>();
    private volatile boolean open = true;

    public BlackHoleAutodetectProcess(String jobId) {
        this.jobId = jobId;
        this.startTime = ZonedDateTime.now();
    }

    @Override
    public void restoreState(StateStreamer stateStreamer, ModelSnapshot modelSnapshot) {
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void writeRecord(String[] record) throws IOException {
    }

    @Override
    public void writeResetBucketsControlMessage(DataLoadParams params) throws IOException {
    }

    @Override
    public void writeUpdateModelPlotMessage(ModelPlotConfig modelPlotConfig) throws IOException {
    }

    @Override
    public void writeUpdateDetectorRulesMessage(int detectorIndex, List<DetectionRule> rules) throws IOException {
    }

    @Override
    public String flushJob(FlushJobParams params) throws IOException {
        FlushAcknowledgement flushAcknowledgement = new FlushAcknowledgement(FLUSH_ID, null);
        AutodetectResult result = new AutodetectResult(null, null, null, null, null, null, null, null, flushAcknowledgement);
        this.results.add(result);
        return FLUSH_ID;
    }

    @Override
    public void flushStream() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            Quantiles quantiles = new Quantiles(this.jobId, new Date(), "black hole quantiles");
            AutodetectResult result = new AutodetectResult(null, null, null, quantiles, null, null, null, null, null);
            this.results.add(result);
            this.open = false;
        }
    }

    @Override
    public void kill() throws IOException {
        this.open = false;
    }

    @Override
    public Iterator<AutodetectResult> readAutodetectResults() {
        return new Iterator<AutodetectResult>(){
            AutodetectResult result;

            @Override
            public boolean hasNext() {
                try {
                    while (BlackHoleAutodetectProcess.this.open) {
                        this.result = (AutodetectResult)((Object)BlackHoleAutodetectProcess.this.results.poll(100L, TimeUnit.MILLISECONDS));
                        if (this.result == null) continue;
                        return true;
                    }
                    this.result = (AutodetectResult)((Object)BlackHoleAutodetectProcess.this.results.poll());
                    return this.result != null;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }

            @Override
            public AutodetectResult next() {
                return this.result;
            }
        };
    }

    @Override
    public ZonedDateTime getProcessStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isProcessAlive() {
        return this.open;
    }

    @Override
    public String readError() {
        return "";
    }
}

