/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.chunked;

import java.util.Objects;
import org.elasticsearch.client.Client;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.chunked.ChunkedDataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.chunked.ChunkedDataExtractorContext;
import org.elasticsearch.xpack.ml.job.config.Job;

public class ChunkedDataExtractorFactory
implements DataExtractorFactory {
    private final Client client;
    private final DatafeedConfig datafeedConfig;
    private final Job job;
    private final DataExtractorFactory dataExtractorFactory;

    public ChunkedDataExtractorFactory(Client client, DatafeedConfig datafeedConfig, Job job, DataExtractorFactory dataExtractorFactory) {
        this.client = Objects.requireNonNull(client);
        this.datafeedConfig = Objects.requireNonNull(datafeedConfig);
        this.job = Objects.requireNonNull(job);
        this.dataExtractorFactory = Objects.requireNonNull(dataExtractorFactory);
    }

    @Override
    public DataExtractor newExtractor(long start, long end) {
        ChunkedDataExtractorContext dataExtractorContext = new ChunkedDataExtractorContext(this.job.getId(), this.job.getDataDescription().getTimeField(), this.datafeedConfig.getIndices(), this.datafeedConfig.getTypes(), this.datafeedConfig.getQuery(), this.datafeedConfig.getScrollSize(), start, end, this.datafeedConfig.getChunkingConfig().getTimeSpan());
        return new ChunkedDataExtractor(this.client, this.dataExtractorFactory, dataExtractorContext);
    }
}

