/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.DatafeedJobValidator;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.datafeed.DatafeedNodeSelector;
import org.elasticsearch.xpack.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.JobState;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.persistent.AllocatedPersistentTask;
import org.elasticsearch.xpack.persistent.PersistentTaskParams;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.persistent.PersistentTasksExecutor;
import org.elasticsearch.xpack.persistent.PersistentTasksService;
import org.elasticsearch.xpack.security.InternalClient;

public class StartDatafeedAction
extends Action<Request, Response, RequestBuilder> {
    public static final ParseField START_TIME = new ParseField("start", new String[0]);
    public static final ParseField END_TIME = new ParseField("end", new String[0]);
    public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
    public static final StartDatafeedAction INSTANCE = new StartDatafeedAction();
    public static final String NAME = "cluster:admin/xpack/ml/datafeed/start";
    public static final String TASK_NAME = "xpack/ml/datafeed";

    private StartDatafeedAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    static void validate(String datafeedId, MlMetadata mlMetadata, PersistentTasksCustomMetaData tasks) {
        DatafeedConfig datafeed;
        DatafeedConfig datafeedConfig = datafeed = mlMetadata == null ? null : mlMetadata.getDatafeed(datafeedId);
        if (datafeed == null) {
            throw ExceptionsHelper.missingDatafeedException(datafeedId);
        }
        Job job = mlMetadata.getJobs().get(datafeed.getJobId());
        if (job == null) {
            throw ExceptionsHelper.missingJobException(datafeed.getJobId());
        }
        DatafeedJobValidator.validate(datafeed, job);
        JobState jobState = MlMetadata.getJobState(datafeed.getJobId(), tasks);
        if (!jobState.isAnyOf(JobState.OPENING, JobState.OPENED)) {
            throw ExceptionsHelper.conflictStatusException("cannot start datafeed [" + datafeedId + "] because job [" + job.getId() + "] is " + (Object)((Object)jobState), new Object[0]);
        }
    }

    public static class StartDatafeedPersistentTasksExecutor
    extends PersistentTasksExecutor<DatafeedParams> {
        private final DatafeedManager datafeedManager;
        private final IndexNameExpressionResolver resolver;

        public StartDatafeedPersistentTasksExecutor(Settings settings, DatafeedManager datafeedManager) {
            super(settings, StartDatafeedAction.TASK_NAME, "ml_utility");
            this.datafeedManager = datafeedManager;
            this.resolver = new IndexNameExpressionResolver(settings);
        }

        @Override
        public PersistentTasksCustomMetaData.Assignment getAssignment(DatafeedParams params, ClusterState clusterState) {
            return new DatafeedNodeSelector(clusterState, this.resolver, params.getDatafeedId()).selectNode();
        }

        @Override
        public void validate(DatafeedParams params, ClusterState clusterState) {
            MlMetadata mlMetadata = (MlMetadata)clusterState.metaData().custom("ml");
            PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)clusterState.getMetaData().custom("persistent_tasks");
            StartDatafeedAction.validate(params.getDatafeedId(), mlMetadata, tasks);
            new DatafeedNodeSelector(clusterState, this.resolver, params.getDatafeedId()).checkDatafeedTaskCanBeCreated();
        }

        @Override
        protected void nodeOperation(AllocatedPersistentTask allocatedPersistentTask, DatafeedParams params) {
            DatafeedTask datafeedTask = (DatafeedTask)allocatedPersistentTask;
            datafeedTask.datafeedManager = this.datafeedManager;
            this.datafeedManager.run(datafeedTask, error -> {
                if (error != null) {
                    datafeedTask.markAsFailed((Exception)error);
                } else {
                    datafeedTask.markAsCompleted();
                }
            });
        }

        @Override
        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<DatafeedParams> persistentTask) {
            return new DatafeedTask(id, type, action, parentTaskId, persistentTask.getParams());
        }
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, Response> {
        private final InternalClient client;
        private final XPackLicenseState licenseState;
        private final PersistentTasksService persistentTasksService;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, XPackLicenseState licenseState, PersistentTasksService persistentTasksService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, InternalClient client) {
            super(settings, StartDatafeedAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.licenseState = licenseState;
            this.persistentTasksService = persistentTasksService;
            this.client = client;
        }

        protected String executor() {
            return "same";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected void masterOperation(Request request, ClusterState state, final ActionListener<Response> listener) throws Exception {
            final DatafeedParams params = request.params;
            if (this.licenseState.isMachineLearningAllowed()) {
                ActionListener<PersistentTasksCustomMetaData.PersistentTask<DatafeedParams>> finalListener = new ActionListener<PersistentTasksCustomMetaData.PersistentTask<DatafeedParams>>(){

                    public void onResponse(PersistentTasksCustomMetaData.PersistentTask<DatafeedParams> persistentTask) {
                        this.waitForDatafeedStarted(persistentTask.getId(), params, (ActionListener<Response>)listener);
                    }

                    public void onFailure(Exception e) {
                        if (e instanceof ResourceAlreadyExistsException) {
                            logger.debug((Object)e);
                            e = new ElasticsearchStatusException("cannot start datafeed [" + params.getDatafeedId() + "] because it has already been started", RestStatus.CONFLICT, new Object[0]);
                        }
                        listener.onFailure(e);
                    }
                };
                MlMetadata mlMetadata = (MlMetadata)state.metaData().custom("ml");
                PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
                StartDatafeedAction.validate(params.getDatafeedId(), mlMetadata, tasks);
                DatafeedConfig datafeed = mlMetadata.getDatafeed(params.getDatafeedId());
                Job job = mlMetadata.getJobs().get(datafeed.getJobId());
                DataExtractorFactory.create((Client)this.client, datafeed, job, (ActionListener<DataExtractorFactory>)ActionListener.wrap(arg_0 -> this.lambda$masterOperation$0(params, (ActionListener)finalListener, arg_0), arg_0 -> listener.onFailure(arg_0)));
            } else {
                listener.onFailure((Exception)((Object)LicenseUtils.newComplianceException("ml")));
            }
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        void waitForDatafeedStarted(String taskId, final DatafeedParams params, final ActionListener<Response> listener) {
            Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> predicate = persistentTask -> {
                if (persistentTask == null) {
                    return false;
                }
                DatafeedState datafeedState = (DatafeedState)persistentTask.getStatus();
                return datafeedState == DatafeedState.STARTED;
            };
            this.persistentTasksService.waitForPersistentTaskStatus(taskId, predicate, params.timeout, new PersistentTasksService.WaitForPersistentTaskStatusListener<DatafeedParams>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<DatafeedParams> task) {
                    listener.onResponse((Object)new Response(true));
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    listener.onFailure((Exception)((Object)new ElasticsearchException("Starting datafeed [" + params.getDatafeedId() + "] timed out after [" + timeout + "]", new Object[0])));
                }
            });
        }

        private /* synthetic */ void lambda$masterOperation$0(DatafeedParams params, ActionListener finalListener, DataExtractorFactory dataExtractorFactory) throws Exception {
            this.persistentTasksService.startPersistentTask(MlMetadata.datafeedTaskId(params.datafeedId), StartDatafeedAction.TASK_NAME, params, finalListener);
        }
    }

    public static class DatafeedTask
    extends AllocatedPersistentTask {
        private final String datafeedId;
        private final long startTime;
        private final Long endTime;
        volatile DatafeedManager datafeedManager;

        DatafeedTask(long id, String type, String action, TaskId parentTaskId, DatafeedParams params) {
            super(id, type, action, "datafeed-" + params.getDatafeedId(), parentTaskId);
            this.datafeedId = params.getDatafeedId();
            this.startTime = params.getStartTime();
            this.endTime = params.getEndTime();
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public long getDatafeedStartTime() {
            return this.startTime;
        }

        @Nullable
        public Long getEndTime() {
            return this.endTime;
        }

        public boolean isLookbackOnly() {
            return this.endTime != null;
        }

        protected void onCancelled() {
            this.stop(this.getReasonCancelled(), TimeValue.ZERO);
        }

        public void stop(String reason, TimeValue timeout) {
            if (this.datafeedManager != null) {
                this.datafeedManager.stopDatafeed(this, reason, timeout);
            }
        }

        public void isolate() {
            if (this.datafeedManager != null) {
                this.datafeedManager.isolateDatafeed(this.getAllocationId());
            }
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, StartDatafeedAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Response
    extends AcknowledgedResponse {
        public Response() {
        }

        public Response(boolean acknowledged) {
            super(acknowledged);
        }

        public void readFrom(StreamInput in) throws IOException {
            this.readAcknowledged(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.writeAcknowledged(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            AcknowledgedResponse that = (AcknowledgedResponse)o;
            return this.isAcknowledged() == that.isAcknowledged();
        }

        public int hashCode() {
            return Objects.hash(this.isAcknowledged());
        }
    }

    public static class DatafeedParams
    implements PersistentTaskParams {
        public static ObjectParser<DatafeedParams, Void> PARSER = new ObjectParser("xpack/ml/datafeed", DatafeedParams::new);
        private String datafeedId;
        private long startTime;
        private Long endTime;
        private TimeValue timeout = TimeValue.timeValueSeconds((long)20L);

        static long parseDateOrThrow(String date, ParseField paramName, LongSupplier now) {
            DateMathParser dateMathParser = new DateMathParser(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER);
            try {
                return dateMathParser.parse(date, now);
            }
            catch (Exception e) {
                String msg = Messages.getMessage("Query param ''{0}'' with value ''{1}'' cannot be parsed as a date or converted to a number (epoch).", paramName.getPreferredName(), date);
                throw new ElasticsearchParseException(msg, (Throwable)e, new Object[0]);
            }
        }

        public static DatafeedParams fromXContent(XContentParser parser) {
            return DatafeedParams.parseRequest(null, parser);
        }

        public static DatafeedParams parseRequest(String datafeedId, XContentParser parser) {
            DatafeedParams params = (DatafeedParams)PARSER.apply(parser, null);
            if (datafeedId != null) {
                params.datafeedId = datafeedId;
            }
            return params;
        }

        public DatafeedParams(String datafeedId, long startTime) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
            this.startTime = startTime;
        }

        public DatafeedParams(String datafeedId, String startTime) {
            this(datafeedId, DatafeedParams.parseDateOrThrow(startTime, START_TIME, System::currentTimeMillis));
        }

        public DatafeedParams(StreamInput in) throws IOException {
            this.datafeedId = in.readString();
            this.startTime = in.readVLong();
            this.endTime = in.readOptionalLong();
            this.timeout = TimeValue.timeValueMillis((long)in.readVLong());
        }

        DatafeedParams() {
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.setEndTime(DatafeedParams.parseDateOrThrow(endTime, END_TIME, System::currentTimeMillis));
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public void setTimeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        public String getWriteableName() {
            return StartDatafeedAction.TASK_NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.datafeedId);
            out.writeVLong(this.startTime);
            out.writeOptionalLong(this.endTime);
            out.writeVLong(this.timeout.millis());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
            builder.field(START_TIME.getPreferredName(), String.valueOf(this.startTime));
            if (this.endTime != null) {
                builder.field(END_TIME.getPreferredName(), String.valueOf(this.endTime));
            }
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId, this.startTime, this.endTime, this.timeout);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DatafeedParams other = (DatafeedParams)obj;
            return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.timeout, other.timeout);
        }

        static {
            PARSER.declareString((params, datafeedId) -> {
                params.datafeedId = datafeedId;
            }, DatafeedConfig.ID);
            PARSER.declareString((params, startTime) -> {
                params.startTime = DatafeedParams.parseDateOrThrow(startTime, START_TIME, System::currentTimeMillis);
            }, START_TIME);
            PARSER.declareString(DatafeedParams::setEndTime, END_TIME);
            PARSER.declareString((params, val) -> params.setTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContent {
        private DatafeedParams params;

        public static Request fromXContent(XContentParser parser) {
            return Request.parseRequest(null, parser);
        }

        public static Request parseRequest(String datafeedId, XContentParser parser) {
            DatafeedParams params = (DatafeedParams)DatafeedParams.PARSER.apply(parser, null);
            if (datafeedId != null) {
                params.datafeedId = datafeedId;
            }
            return new Request(params);
        }

        public Request(String datafeedId, long startTime) {
            this.params = new DatafeedParams(datafeedId, startTime);
        }

        public Request(String datafeedId, String startTime) {
            this.params = new DatafeedParams(datafeedId, startTime);
        }

        public Request(DatafeedParams params) {
            this.params = params;
        }

        public Request(StreamInput in) throws IOException {
            this.readFrom(in);
        }

        Request() {
        }

        public DatafeedParams getParams() {
            return this.params;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = null;
            if (this.params.endTime != null && this.params.endTime <= this.params.startTime) {
                e = ValidateActions.addValidationError((String)(START_TIME.getPreferredName() + " [" + this.params.startTime + "] must be earlier than " + END_TIME.getPreferredName() + " [" + this.params.endTime + "]"), e);
            }
            return e;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.params = new DatafeedParams(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.params.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.params.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.params);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.params, other.params);
        }
    }
}

