/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.action.util.PageParams;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class GetCategoriesAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetCategoriesAction INSTANCE = new GetCategoriesAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/results/categories/get";

    private GetCategoriesAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final JobProvider jobProvider;
        private final Client client;
        private final JobManager jobManager;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobProvider jobProvider, Client client, JobManager jobManager) {
            super(settings, GetCategoriesAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, Request::new);
            this.jobProvider = jobProvider;
            this.client = client;
            this.jobManager = jobManager;
        }

        protected void doExecute(Request request, ActionListener<Response> listener) {
            this.jobManager.getJobOrThrowIfUnknown(request.jobId);
            Integer from = request.pageParams != null ? Integer.valueOf(request.pageParams.getFrom()) : null;
            Integer size = request.pageParams != null ? Integer.valueOf(request.pageParams.getSize()) : null;
            this.jobProvider.categoryDefinitions(request.jobId, request.categoryId, from, size, r -> listener.onResponse((Object)new Response((QueryPage<CategoryDefinition>)((Object)r))), arg_0 -> listener.onFailure(arg_0), this.client);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private QueryPage<CategoryDefinition> result;

        public Response(QueryPage<CategoryDefinition> result) {
            this.result = result;
        }

        Response() {
        }

        public QueryPage<CategoryDefinition> getResult() {
            return this.result;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.result = new QueryPage(in, CategoryDefinition::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.result.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.result.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.result, response.result);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.result});
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, GetCategoriesAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContent {
        public static final ParseField CATEGORY_ID = new ParseField("category_id", new String[0]);
        public static final ParseField FROM = new ParseField("from", new String[0]);
        public static final ParseField SIZE = new ParseField("size", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/job/results/categories/get", Request::new);
        private String jobId;
        private Long categoryId;
        private PageParams pageParams;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        Request() {
        }

        public void setCategoryId(Long categoryId) {
            if (this.pageParams != null) {
                throw new IllegalArgumentException("Param [" + CATEGORY_ID.getPreferredName() + "] is incompatible with [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "].");
            }
            this.categoryId = ExceptionsHelper.requireNonNull(categoryId, CATEGORY_ID.getPreferredName());
        }

        public void setPageParams(PageParams pageParams) {
            if (this.categoryId != null) {
                throw new IllegalArgumentException("Param [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "] is incompatible with [" + CATEGORY_ID.getPreferredName() + "].");
            }
            this.pageParams = pageParams;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.pageParams == null && this.categoryId == null) {
                validationException = ValidateActions.addValidationError((String)("Both [" + CATEGORY_ID.getPreferredName() + "] and [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "] cannot be null"), validationException);
            }
            return validationException;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.categoryId = in.readOptionalLong();
            this.pageParams = (PageParams)in.readOptionalWriteable(PageParams::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeOptionalLong(this.categoryId);
            out.writeOptionalWriteable((Writeable)this.pageParams);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            if (this.categoryId != null) {
                builder.field(CATEGORY_ID.getPreferredName(), this.categoryId);
            }
            if (this.pageParams != null) {
                builder.field(PageParams.PAGE.getPreferredName(), (ToXContent)this.pageParams);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.jobId, request.jobId) && Objects.equals(this.categoryId, request.categoryId) && Objects.equals((Object)this.pageParams, (Object)request.pageParams);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.jobId, this.categoryId, this.pageParams});
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareLong(Request::setCategoryId, CATEGORY_ID);
            PARSER.declareObject(Request::setPageParams, PageParams.PARSER, PageParams.PAGE);
        }
    }
}

