/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.xpack.deprecation.ClusterDeprecationChecks;
import org.elasticsearch.xpack.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.IndexDeprecationChecks;
import org.elasticsearch.xpack.deprecation.NodeDeprecationChecks;

public class DeprecationChecks {
    static List<Function<ClusterState, DeprecationIssue>> CLUSTER_SETTINGS_CHECKS = Collections.unmodifiableList(Arrays.asList(ClusterDeprecationChecks::ingestNewDateFormatCheck, ClusterDeprecationChecks::networkSettingCheck, ClusterDeprecationChecks::snapshotSettingsCheck, ClusterDeprecationChecks::storeThrottlingSettingCheck, ClusterDeprecationChecks::templateNowIndexPatternsCheck, ClusterDeprecationChecks::checkMappingInTemplate));
    static List<BiFunction<List<NodeInfo>, List<NodeStats>, DeprecationIssue>> NODE_SETTINGS_CHECKS = Collections.unmodifiableList(Arrays.asList(NodeDeprecationChecks::azureRepositoryChanges, NodeDeprecationChecks::bit32NotMaintained, NodeDeprecationChecks::clusterNameNotAllowedInNodePathCheck, NodeDeprecationChecks::discoverySettingsChanged, NodeDeprecationChecks::defaultPathSettingsRemoved, NodeDeprecationChecks::ec2DiscoveryChanges, NodeDeprecationChecks::gcsRepositoryChanges, NodeDeprecationChecks::pathConfNoLongerAllowed, NodeDeprecationChecks::pythonJavascriptPluginsRemoved, NodeDeprecationChecks::s3RepositoryChanges, NodeDeprecationChecks::scriptSettingsChanged, NodeDeprecationChecks::snapshotSettingsCheck, NodeDeprecationChecks::networkSettingCheck, NodeDeprecationChecks::storeThrottlingSettingCheck, NodeDeprecationChecks::ingestNewDateFormatCheck));
    static List<Function<IndexMetaData, DeprecationIssue>> INDEX_SETTINGS_CHECKS = Collections.unmodifiableList(Arrays.asList(IndexDeprecationChecks::allMetaFieldIsDisabledByDefaultCheck, IndexDeprecationChecks::baseSimilarityDefinedCheck, IndexDeprecationChecks::coercionCheck, IndexDeprecationChecks::dynamicTemplateWithMatchMappingTypeCheck, IndexDeprecationChecks::includeInAllCheck, IndexDeprecationChecks::indexSharedFileSystemCheck, IndexDeprecationChecks::indexStoreTypeCheck, IndexDeprecationChecks::mapperAttachmentUsage, IndexDeprecationChecks::oldIndicesCheck, IndexDeprecationChecks::storeThrottleSettingsCheck, IndexDeprecationChecks::synonmTokenFilter, IndexDeprecationChecks::usesICUAnalysis));

    private DeprecationChecks() {
    }

    static <T> List<DeprecationIssue> filterChecks(List<T> checks, Function<T, DeprecationIssue> mapper) {
        return checks.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

