/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.deprecation.DeprecationChecks;
import org.elasticsearch.xpack.deprecation.DeprecationIssue;

public class ClusterDeprecationChecks {
    static DeprecationIssue snapshotSettingsCheck(ClusterState state) {
        return ClusterDeprecationChecks.snapshotSettingsCheck(state.getMetaData().settings());
    }

    static DeprecationIssue snapshotSettingsCheck(Settings settings) {
        if (settings.get("cluster.routing.allocation.snapshot.relocation_enabled") != null) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Internal reallocation of shards with running snapshots disallowed", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_settings_changes.html#_snapshot_settings", null);
        }
        return null;
    }

    static DeprecationIssue storeThrottlingSettingCheck(ClusterState state) {
        return ClusterDeprecationChecks.storeThrottlingSettingCheck(state.getMetaData().settings());
    }

    static DeprecationIssue storeThrottlingSettingCheck(Settings settings) {
        Settings throttleSettings = settings.getAsSettings("indices.store.throttle");
        ArrayList<String> settingsFound = new ArrayList<String>();
        if (throttleSettings.get("max_bytes_per_sec") != null) {
            settingsFound.add("indices.store.throttle.max_bytes_per_sec");
        }
        if (throttleSettings.get("type") != null) {
            settingsFound.add("indices.store.throttle.type");
        }
        if (settingsFound.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Store throttling type setting", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_settings_changes.html#_store_throttling_settings", "settings found: " + settingsFound);
        }
        return null;
    }

    static DeprecationIssue networkSettingCheck(ClusterState state) {
        return ClusterDeprecationChecks.networkSettingCheck(state.getMetaData().settings());
    }

    static DeprecationIssue networkSettingCheck(Settings settings) {
        List<String> unrecognizedSettings = Arrays.asList("network.tcp.blocking_server", "network.tcp.blocking_client", "network.tcp.blocking", "transport.tcp.blocking_client", "transport.tcp.blocking_server", "http.tcp.blocking_server");
        String found = unrecognizedSettings.stream().filter(s -> settings.get(s) != null).collect(Collectors.joining(", "));
        if (found.length() > 0) {
            String details = "these existing network settings will not be supported in Elasticsearch 6.0: " + found;
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Network settings changes", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_settings_changes.html#_network_settings", details);
        }
        return null;
    }

    static DeprecationIssue templateNowIndexPatternsCheck(ClusterState state) {
        String templates = StreamSupport.stream(state.getMetaData().templates().spliterator(), false).map(ooc -> (String)ooc.key).collect(Collectors.joining(","));
        if (templates.length() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.NONE, "Template patterns are no longer using `template` field, but `index_patterns` instead", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_indices_changes.html#_index_templates_use_literal_index_patterns_literal_instead_of_literal_template_literal", "templates using `template` field: " + templates);
        }
        return null;
    }

    static DeprecationIssue ingestNewDateFormatCheck(ClusterState state) {
        return ClusterDeprecationChecks.ingestNewDateFormatCheck(state.getMetaData().settings());
    }

    static DeprecationIssue ingestNewDateFormatCheck(Settings settings) {
        if (settings.getAsBoolean("ingest.new_date_format", Boolean.valueOf(false)).booleanValue()) {
            return new DeprecationIssue(DeprecationIssue.Level.INFO, "Ingest Pipelines default to new date format", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_ingest_changes.html#_the_format_of_the_string_formatted_ingest_timestamp_field_has_changed", null);
        }
        return null;
    }

    static DeprecationIssue checkMappingInTemplate(ClusterState state) {
        List templates = StreamSupport.stream(state.getMetaData().templates().spliterator(), false).map(ooc -> (IndexTemplateMetaData)ooc.value).collect(Collectors.toList());
        HashMap<String, String> templateIssueMap = new HashMap<String, String>();
        DeprecationIssue.Level maxSeverityLevel = DeprecationIssue.Level.NONE;
        for (IndexTemplateMetaData template : templates) {
            IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.builder((String)"template").settings(Settings.builder().put("index.version.created", Version.V_5_6_0)).numberOfShards(1).numberOfReplicas(0);
            try {
                for (ObjectObjectCursor mapping : template.getMappings()) {
                    indexMetaDataBuilder.putMapping((String)mapping.key, ((CompressedXContent)mapping.value).string());
                }
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("Unable to build index metadata to check template mapping", (Throwable)e, new Object[0]);
            }
            IndexMetaData indexMetaData = indexMetaDataBuilder.build();
            List<DeprecationIssue> foundIssues = DeprecationChecks.filterChecks(DeprecationChecks.INDEX_SETTINGS_CHECKS, c -> (DeprecationIssue)c.apply(indexMetaData));
            if (foundIssues.isEmpty()) continue;
            DeprecationIssue mostSevereIssue = Collections.max(foundIssues, Comparator.comparing(DeprecationIssue::getLevel));
            if (mostSevereIssue.getLevel().compareTo(maxSeverityLevel) > 0) {
                maxSeverityLevel = mostSevereIssue.getLevel();
            }
            List issueMessages = foundIssues.stream().map(DeprecationIssue::getMessage).collect(Collectors.toList());
            templateIssueMap.put(template.getName(), issueMessages.toString());
        }
        if (templateIssueMap.size() > 0) {
            return new DeprecationIssue(maxSeverityLevel, "one or more templates use deprecated mapping settings", "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_indices_changes.html", ((Object)templateIssueMap).toString());
        }
        return null;
    }
}

