/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.action;

import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.XPackInfoResponse;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.XPackBuild;
import org.elasticsearch.xpack.XPackFeatureSet;
import org.elasticsearch.xpack.action.XPackInfoRequest;

public class TransportXPackInfoAction
extends HandledTransportAction<XPackInfoRequest, XPackInfoResponse> {
    private final LicenseService licenseService;
    private final Set<XPackFeatureSet> featureSets;

    @Inject
    public TransportXPackInfoAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, LicenseService licenseService, Set<XPackFeatureSet> featureSets) {
        super(settings, "cluster:monitor/xpack/info", threadPool, transportService, actionFilters, indexNameExpressionResolver, XPackInfoRequest::new);
        this.licenseService = licenseService;
        this.featureSets = featureSets;
    }

    protected void doExecute(XPackInfoRequest request, ActionListener<XPackInfoResponse> listener) {
        License license;
        XPackInfoResponse.BuildInfo buildInfo = null;
        if (request.getCategories().contains((Object)XPackInfoRequest.Category.BUILD)) {
            buildInfo = new XPackInfoResponse.BuildInfo(XPackBuild.CURRENT);
        }
        XPackInfoResponse.LicenseInfo licenseInfo = null;
        if (request.getCategories().contains((Object)XPackInfoRequest.Category.LICENSE) && (license = this.licenseService.getLicense()) != null) {
            licenseInfo = new XPackInfoResponse.LicenseInfo(license);
        }
        XPackInfoResponse.FeatureSetsInfo featureSetsInfo = null;
        if (request.getCategories().contains((Object)XPackInfoRequest.Category.FEATURES)) {
            Set<XPackInfoResponse.FeatureSetsInfo.FeatureSet> featureSets = this.featureSets.stream().map(fs -> new XPackInfoResponse.FeatureSetsInfo.FeatureSet(fs.name(), request.isVerbose() ? fs.description() : null, fs.available(), fs.enabled(), request.isVerbose() ? fs.nativeCodeInfo() : null)).collect(Collectors.toSet());
            featureSetsInfo = new XPackInfoResponse.FeatureSetsInfo(featureSets);
        }
        listener.onResponse((Object)new XPackInfoResponse(buildInfo, licenseInfo, featureSetsInfo));
    }
}

