/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.elasticsearch.xpack.watcher.trigger.schedule.Cron;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;

public abstract class CronnableSchedule
implements Schedule {
    private static final Comparator<Cron> CRON_COMPARATOR = new Comparator<Cron>(){

        @Override
        public int compare(Cron c1, Cron c2) {
            return c1.expression().compareTo(c2.expression());
        }
    };
    protected final Cron[] crons;

    public CronnableSchedule(String ... expressions) {
        this(CronnableSchedule.crons(expressions));
    }

    public CronnableSchedule(Cron ... crons) {
        assert (crons.length > 0);
        this.crons = crons;
        Arrays.sort(crons, CRON_COMPARATOR);
    }

    @Override
    public long nextScheduledTimeAfter(long startTime, long time) {
        assert (time >= startTime);
        long nextTime = Long.MAX_VALUE;
        for (Cron cron : this.crons) {
            nextTime = Math.min(nextTime, cron.getNextValidTimeAfter(time));
        }
        return nextTime;
    }

    public Cron[] crons() {
        return this.crons;
    }

    public int hashCode() {
        return Objects.hash(this.crons);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CronnableSchedule other = (CronnableSchedule)obj;
        return Objects.deepEquals(this.crons, other.crons);
    }

    static Cron[] crons(String ... expressions) {
        Cron[] crons = new Cron[expressions.length];
        for (int i = 0; i < crons.length; ++i) {
            crons[i] = new Cron(expressions[i]);
        }
        return crons;
    }
}

