/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.slack;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.slack.SentMessages;
import org.elasticsearch.xpack.notification.slack.SlackAccount;
import org.elasticsearch.xpack.notification.slack.SlackService;
import org.elasticsearch.xpack.notification.slack.message.SlackMessage;
import org.elasticsearch.xpack.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.watcher.actions.slack.SlackAction;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class ExecutableSlackAction
extends ExecutableAction<SlackAction> {
    private final TextTemplateEngine templateEngine;
    private final SlackService slackService;

    public ExecutableSlackAction(SlackAction action, Logger logger, SlackService slackService, TextTemplateEngine templateEngine) {
        super(action, logger);
        this.slackService = slackService;
        this.templateEngine = templateEngine;
    }

    @Override
    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        SlackAccount account = (SlackAccount)this.slackService.getAccount(((SlackAction)this.action).account);
        if (account == null) {
            throw new IllegalStateException("account [" + ((SlackAction)this.action).account + "] was not found. perhaps it was deleted");
        }
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        SlackMessage message = ((SlackAction)this.action).message.render(ctx.id().watchId(), actionId, this.templateEngine, model, account.getMessageDefaults());
        if (ctx.simulateAction(actionId)) {
            return new SlackAction.Result.Simulated(message);
        }
        SentMessages sentMessages = account.send(message, ((SlackAction)this.action).proxy);
        return new SlackAction.Result.Executed(sentMessages);
    }
}

