/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.watcher.actions.index.IndexAction;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.ArrayObjectIterator;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.watcher.support.init.proxy.WatcherClientProxy;
import org.elasticsearch.xpack.watcher.support.xcontent.XContentSource;
import org.elasticsearch.xpack.watcher.watch.Payload;
import org.joda.time.DateTime;

public class ExecutableIndexAction
extends ExecutableAction<IndexAction> {
    public static final String ID_FIELD = "_id";
    private final WatcherClientProxy client;
    private final TimeValue timeout;

    public ExecutableIndexAction(IndexAction action, Logger logger, WatcherClientProxy client, @Nullable TimeValue defaultTimeout) {
        super(action, logger);
        this.client = client;
        this.timeout = action.timeout != null ? action.timeout : defaultTimeout;
    }

    @Override
    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        BytesReference bytesReference;
        Map<String, Object> data = payload.data();
        if (data.containsKey("_doc")) {
            Object doc = data.get("_doc");
            if (doc instanceof Iterable) {
                return this.indexBulk((Iterable)doc, actionId, ctx);
            }
            if (doc.getClass().isArray()) {
                return this.indexBulk(new ArrayObjectIterator.Iterable(doc), actionId, ctx);
            }
            if (doc instanceof Map) {
                data = (Map<String, Object>)doc;
            } else {
                throw Exceptions.illegalState("could not execute action [{}] of watch [{}]. failed to index payload data.[_data] field must either hold a Map or an List/Array of Maps", actionId, ctx.watch().id());
            }
        }
        String docId = ((IndexAction)this.action).docId;
        if (data.containsKey(ID_FIELD)) {
            if (docId != null) {
                throw Exceptions.illegalState("could not execute action [{}] of watch [{}]. [ctx.payload.{}] or [ctx.payload._doc.{}] were set with [doc_id]. Only set [{}] or [doc_id]", actionId, ctx.watch().id(), ID_FIELD, ID_FIELD, ID_FIELD);
            }
            data = this.mutableMap(data);
            docId = data.remove(ID_FIELD).toString();
        }
        IndexRequest indexRequest = new IndexRequest();
        indexRequest.index(((IndexAction)this.action).index);
        indexRequest.type(((IndexAction)this.action).docType);
        indexRequest.id(docId);
        data = this.addTimestampToDocument(data, ctx.executionTime());
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            indexRequest.source(builder.prettyPrint().map(data));
        }
        if (ctx.simulateAction(actionId)) {
            return new IndexAction.Simulated(indexRequest.index(), ((IndexAction)this.action).docType, docId, new XContentSource(indexRequest.source(), XContentType.JSON));
        }
        IndexResponse response = this.client.index(indexRequest, this.timeout);
        builder = XContentFactory.jsonBuilder();
        var10_8 = null;
        try {
            ExecutableIndexAction.indexResponseToXContent(builder, response);
            bytesReference = builder.bytes();
        }
        catch (Throwable throwable) {
            var10_8 = throwable;
            throw throwable;
        }
        finally {
            if (builder != null) {
                if (var10_8 != null) {
                    try {
                        builder.close();
                    }
                    catch (Throwable throwable) {
                        var10_8.addSuppressed(throwable);
                    }
                } else {
                    builder.close();
                }
            }
        }
        return new IndexAction.Result(Action.Result.Status.SUCCESS, new XContentSource(bytesReference, XContentType.JSON));
    }

    Action.Result indexBulk(Iterable list, String actionId, WatchExecutionContext ctx) throws Exception {
        Object object;
        if (((IndexAction)this.action).docId != null) {
            throw Exceptions.illegalState("could not execute action [{}] of watch [{}]. [doc_id] cannot be used with bulk [_doc] indexing", new Object[0]);
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (Object item : list) {
            if (!(item instanceof Map)) {
                throw Exceptions.illegalState("could not execute action [{}] of watch [{}]. failed to index payload data. [_data] field must either hold a Map or an List/Array of Maps", actionId, ctx.watch().id());
            }
            Map<String, Object> doc = (Map<String, Object>)item;
            IndexRequest indexRequest = new IndexRequest();
            indexRequest.index(((IndexAction)this.action).index);
            indexRequest.type(((IndexAction)this.action).docType);
            if (doc.containsKey(ID_FIELD)) {
                doc = this.mutableMap(doc);
                indexRequest.id(doc.remove(ID_FIELD).toString());
            }
            doc = this.addTimestampToDocument(doc, ctx.executionTime());
            XContentBuilder builder = XContentFactory.jsonBuilder();
            object = null;
            try {
                indexRequest.source(builder.prettyPrint().map(doc));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (builder != null) {
                    if (object != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        builder.close();
                    }
                }
            }
            bulkRequest.add(indexRequest);
        }
        BulkResponse bulkResponse = this.client.bulk(bulkRequest, ((IndexAction)this.action).timeout);
        try (XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().startArray();){
            for (BulkItemResponse item : bulkResponse) {
                ExecutableIndexAction.itemResponseToXContent(jsonBuilder, item);
            }
            jsonBuilder.endArray();
            long failures = Stream.of(bulkResponse.getItems()).filter(BulkItemResponse::isFailed).count();
            if (failures == 0L) {
                object = new IndexAction.Result(Action.Result.Status.SUCCESS, new XContentSource(jsonBuilder.bytes(), XContentType.JSON));
                return object;
            }
            if (failures == (long)bulkResponse.getItems().length) {
                object = new IndexAction.Result(Action.Result.Status.FAILURE, new XContentSource(jsonBuilder.bytes(), XContentType.JSON));
                return object;
            }
            object = new IndexAction.Result(Action.Result.Status.PARTIAL_FAILURE, new XContentSource(jsonBuilder.bytes(), XContentType.JSON));
            return object;
        }
    }

    private Map<String, Object> addTimestampToDocument(Map<String, Object> data, DateTime executionTime) {
        if (((IndexAction)this.action).executionTimeField != null) {
            data = this.mutableMap(data);
            data.put(((IndexAction)this.action).executionTimeField, WatcherDateTimeUtils.formatDate(executionTime));
        }
        return data;
    }

    private Map<String, Object> mutableMap(Map<String, Object> data) {
        return data instanceof HashMap ? data : new HashMap(data);
    }

    static void itemResponseToXContent(XContentBuilder builder, BulkItemResponse item) throws IOException {
        if (item.isFailed()) {
            builder.startObject().field("failed", item.isFailed()).field("message", item.getFailureMessage()).field("id", item.getId()).field("type", item.getType()).field("index", item.getIndex()).endObject();
        } else {
            ExecutableIndexAction.indexResponseToXContent(builder, (IndexResponse)item.getResponse());
        }
    }

    static void indexResponseToXContent(XContentBuilder builder, IndexResponse response) throws IOException {
        builder.startObject().field("created", response.getResult() == DocWriteResponse.Result.CREATED).field("result", response.getResult().getLowercase()).field("id", response.getId()).field("version", response.getVersion()).field("type", response.getType()).field("index", response.getIndex()).endObject();
    }
}

