/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.security.SecurityContext;
import org.elasticsearch.xpack.security.action.user.AuthenticateAction;
import org.elasticsearch.xpack.security.action.user.AuthenticateRequest;
import org.elasticsearch.xpack.security.action.user.AuthenticateResponse;
import org.elasticsearch.xpack.security.user.User;

public class RestAuthenticateAction
extends BaseRestHandler {
    private final SecurityContext securityContext;
    private final XPackLicenseState licenseState;

    public RestAuthenticateAction(Settings settings, RestController controller, SecurityContext securityContext, XPackLicenseState licenseState) {
        super(settings);
        this.securityContext = securityContext;
        this.licenseState = licenseState;
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/security/_authenticate", (RestHandler)this);
        controller.registerAsDeprecatedHandler(RestRequest.Method.GET, "/_shield/authenticate", (RestHandler)this, "[GET /_shield/authenticate] is deprecated! Use [GET /_xpack/security/_authenticate] instead.", this.deprecationLogger);
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.licenseState.isAuthAllowed()) {
            throw LicenseUtils.newComplianceException("security");
        }
        User user = this.securityContext.getUser();
        assert (user != null);
        String username = user.principal();
        return channel -> client.execute((Action)AuthenticateAction.INSTANCE, (ActionRequest)new AuthenticateRequest(username), (ActionListener)new RestBuilderListener<AuthenticateResponse>(channel){

            public RestResponse buildResponse(AuthenticateResponse authenticateResponse, XContentBuilder builder) throws Exception {
                authenticateResponse.user().toXContent(builder, ToXContent.EMPTY_PARAMS);
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

