/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.user.User;

public abstract class CachingUsernamePasswordRealm
extends UsernamePasswordRealm
implements CachingRealm {
    public static final Setting<String> CACHE_HASH_ALGO_SETTING = Setting.simpleString((String)"cache.hash_algo", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final TimeValue DEFAULT_TTL = TimeValue.timeValueMinutes((long)20L);
    public static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting((String)"cache.ttl", (TimeValue)DEFAULT_TTL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final int DEFAULT_MAX_USERS = 100000;
    public static final Setting<Integer> CACHE_MAX_USERS_SETTING = Setting.intSetting((String)"cache.max_users", (int)100000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Cache<String, UserWithHash> cache;
    final Hasher hasher;

    protected CachingUsernamePasswordRealm(String type, RealmConfig config) {
        super(type, config);
        this.hasher = Hasher.resolve((String)CACHE_HASH_ALGO_SETTING.get(config.settings()), Hasher.SSHA256);
        TimeValue ttl = (TimeValue)CACHE_TTL_SETTING.get(config.settings());
        this.cache = ttl.getNanos() > 0L ? CacheBuilder.builder().setExpireAfterWrite(ttl).setMaximumWeight((long)((Integer)CACHE_MAX_USERS_SETTING.get(config.settings())).intValue()).build() : null;
    }

    @Override
    public final void expire(String username) {
        if (this.cache != null) {
            this.logger.trace("invalidating cache for user [{}] in realm [{}]", (Object)username, (Object)this.name());
            this.cache.invalidate((Object)username);
        }
    }

    @Override
    public final void expireAll() {
        if (this.cache != null) {
            this.logger.trace("invalidating cache for all users in realm [{}]", (Object)this.name());
            this.cache.invalidateAll();
        }
    }

    @Override
    public final void authenticate(AuthenticationToken authToken, ActionListener<User> listener) {
        UsernamePasswordToken token = (UsernamePasswordToken)authToken;
        try {
            if (this.cache == null) {
                this.doAuthenticate(token, listener);
            } else {
                this.authenticateWithCache(token, listener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void authenticateWithCache(UsernamePasswordToken token, ActionListener<User> listener) {
        UserWithHash userWithHash = (UserWithHash)this.cache.get((Object)token.principal());
        if (userWithHash == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("user [{}] not found in cache for realm [{}], proceeding with normal authentication", (Object)token.principal(), (Object)this.name());
            }
            this.doAuthenticateAndCache(token, (ActionListener<User>)ActionListener.wrap(user -> {
                if (user != null) {
                    this.logger.debug("realm [{}] authenticated user [{}], with roles [{}]", (Object)this.name(), (Object)token.principal(), (Object)user.roles());
                }
                listener.onResponse(user);
            }, arg_0 -> listener.onFailure(arg_0)));
        } else if (userWithHash.hasHash()) {
            if (userWithHash.verify(token.credentials())) {
                this.logger.debug("realm [{}] authenticated user [{}], with roles [{}]", (Object)this.name(), (Object)token.principal(), (Object)userWithHash.user.roles());
                listener.onResponse((Object)userWithHash.user);
            } else {
                this.cache.invalidate((Object)token.principal());
                this.doAuthenticateAndCache(token, (ActionListener<User>)ActionListener.wrap(user -> {
                    if (user != null) {
                        this.logger.debug("cached user's password changed. realm [{}] authenticated user [{}], with roles [{}]", (Object)this.name(), (Object)token.principal(), (Object)user.roles());
                    }
                    listener.onResponse(user);
                }, arg_0 -> listener.onFailure(arg_0)));
            }
        } else {
            this.cache.invalidate((Object)token.principal());
            this.doAuthenticateAndCache(token, (ActionListener<User>)ActionListener.wrap(user -> {
                if (user != null) {
                    this.logger.debug("cached user came from a lookup and could not be used for authentication. realm [{}] authenticated user [{}] with roles [{}]", (Object)this.name(), (Object)token.principal(), (Object)user.roles());
                }
                listener.onResponse(user);
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void doAuthenticateAndCache(UsernamePasswordToken token, ActionListener<User> listener) {
        this.doAuthenticate(token, (ActionListener<User>)ActionListener.wrap(user -> {
            if (user == null) {
                listener.onResponse(null);
            } else {
                UserWithHash userWithHash = new UserWithHash((User)user, token.credentials(), this.hasher);
                this.cache.put((Object)token.principal(), (Object)userWithHash);
                listener.onResponse(user);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public Map<String, Object> usageStats() {
        Map<String, Object> stats = super.usageStats();
        stats.put("size", this.cache.count());
        return stats;
    }

    protected abstract void doAuthenticate(UsernamePasswordToken var1, ActionListener<User> var2);

    @Override
    public final void lookupUser(String username, ActionListener<User> listener) {
        if (!this.userLookupSupported()) {
            listener.onResponse(null);
        } else if (this.cache != null) {
            UserWithHash withHash = (UserWithHash)this.cache.get((Object)username);
            if (withHash == null) {
                try {
                    this.doLookupUser(username, (ActionListener<User>)ActionListener.wrap(user -> {
                        Runnable action = () -> listener.onResponse(null);
                        if (user != null) {
                            UserWithHash userWithHash = new UserWithHash((User)user, null, null);
                            try {
                                this.cache.computeIfAbsent((Object)username, n -> userWithHash);
                                action = () -> listener.onResponse((Object)userWithHash.user);
                            }
                            catch (ExecutionException e) {
                                action = () -> listener.onFailure((Exception)e);
                            }
                        }
                        action.run();
                    }, arg_0 -> listener.onFailure(arg_0)));
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            } else {
                listener.onResponse((Object)withHash.user);
            }
        } else {
            this.doLookupUser(username, listener);
        }
    }

    protected abstract void doLookupUser(String var1, ActionListener<User> var2);

    protected static Set<Setting<?>> getCachingSettings() {
        return new HashSet(Arrays.asList(CACHE_HASH_ALGO_SETTING, CACHE_TTL_SETTING, CACHE_MAX_USERS_SETTING));
    }

    private static class UserWithHash {
        User user;
        char[] hash;
        Hasher hasher;

        UserWithHash(User user, SecuredString password, Hasher hasher) {
            this.user = user;
            this.hash = password == null ? null : hasher.hash(password);
            this.hasher = hasher;
        }

        boolean verify(SecuredString password) {
            return this.hash != null && this.hasher.verify(password, this.hash);
        }

        boolean hasHash() {
            return this.hash != null;
        }
    }
}

