/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.security.action.user.UserRequest;

public class GetUsersRequest
extends ActionRequest
implements UserRequest {
    private String[] usernames = Strings.EMPTY_ARRAY;

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.usernames == null) {
            validationException = ValidateActions.addValidationError((String)"usernames cannot be null", validationException);
        }
        return validationException;
    }

    public void usernames(String ... usernames) {
        this.usernames = usernames;
    }

    @Override
    public String[] usernames() {
        return this.usernames;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.usernames = in.readStringArray();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.usernames);
    }
}

