/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.node.Node;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.crypto.CryptoService;
import org.elasticsearch.xpack.security.user.XPackUser;

public class InternalClient
extends FilterClient {
    private final CryptoService cryptoService;
    private final String nodeName;
    private final boolean signingEnabled;

    public InternalClient(Settings settings, ThreadPool threadPool, Client in, CryptoService cryptoService) {
        super(settings, threadPool, in);
        this.cryptoService = cryptoService;
        this.nodeName = (String)Node.NODE_NAME_SETTING.get(settings);
        this.signingEnabled = (Boolean)AuthenticationService.SIGN_USER_HEADER.get(settings);
    }

    protected <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        if (this.cryptoService == null) {
            super.doExecute(action, request, listener);
            return;
        }
        ThreadContext threadContext = this.threadPool().getThreadContext();
        Supplier storedContext = threadContext.newRestorableContext(true);
        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
            this.processContext(threadContext);
            super.doExecute(action, request, (ActionListener)new ContextPreservingActionListener(storedContext, listener));
        }
    }

    protected void processContext(ThreadContext threadContext) {
        try {
            Authentication authentication = new Authentication(XPackUser.INSTANCE, new Authentication.RealmRef("__attach", "__attach", this.nodeName), null);
            authentication.writeToContext(threadContext, this.cryptoService, this.settings, Version.CURRENT, this.signingEnabled);
        }
        catch (IOException ioe) {
            throw new ElasticsearchException("failed to attach internal user to request", (Throwable)ioe, new Object[0]);
        }
    }

    public static <T> void fetchAllByEntity(final Client client, final SearchRequest request, final ActionListener<Collection<T>> listener, final Function<SearchHit, T> hitParser) {
        final ArrayList results = new ArrayList();
        if (request.scroll() == null) {
            request.scroll(TimeValue.timeValueSeconds((long)10L));
        }
        final Consumer<SearchResponse> clearScroll = response -> {
            if (response != null && response.getScrollId() != null) {
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(response.getScrollId());
                client.clearScroll(clearScrollRequest, ActionListener.wrap(r -> {}, e -> {}));
            }
        };
        client.search(request, (ActionListener)new ActionListener<SearchResponse>(){
            private volatile SearchResponse lastResponse = null;

            public void onResponse(SearchResponse resp) {
                try {
                    this.lastResponse = resp;
                    if (resp.getHits().getHits().length > 0) {
                        for (SearchHit hit : resp.getHits().getHits()) {
                            Object oneResult = hitParser.apply(hit);
                            if (oneResult == null) continue;
                            results.add(oneResult);
                        }
                        if ((long)results.size() > resp.getHits().getTotalHits()) {
                            clearScroll.accept(this.lastResponse);
                            listener.onFailure((Exception)new IllegalStateException("scrolling returned more hits [" + results.size() + "] than expected [" + resp.getHits().getTotalHits() + "] so bailing out to prevent unbounded memory consumption."));
                        } else {
                            SearchScrollRequest scrollRequest = new SearchScrollRequest(resp.getScrollId());
                            scrollRequest.scroll(request.scroll().keepAlive());
                            client.searchScroll(scrollRequest, (ActionListener)this);
                        }
                    } else {
                        clearScroll.accept(resp);
                        listener.onResponse(Collections.unmodifiableList(results));
                    }
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception t) {
                try {
                    clearScroll.accept(this.lastResponse);
                }
                finally {
                    if (t instanceof IndexNotFoundException) {
                        listener.onResponse(Collections.emptyList());
                    } else {
                        listener.onFailure(t);
                    }
                }
            }
        });
    }
}

