/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;

public abstract class PublishableHttpResource
extends HttpResource {
    public static final String FILTER_PATH_NONE = "$NONE";
    public static final Map<String, String> NO_BODY_PARAMETERS = Collections.singletonMap("filter_path", "$NONE");
    public static final Set<Integer> GET_EXISTS = Collections.singleton(RestStatus.OK.getStatus());
    public static final Set<Integer> GET_DOES_NOT_EXIST = Collections.singleton(RestStatus.NOT_FOUND.getStatus());
    protected final Map<String, String> parameters;

    protected PublishableHttpResource(String resourceOwnerName, @Nullable TimeValue masterTimeout, Map<String, String> baseParameters) {
        this(resourceOwnerName, masterTimeout, baseParameters, true);
    }

    protected PublishableHttpResource(String resourceOwnerName, @Nullable TimeValue masterTimeout, Map<String, String> baseParameters, boolean dirty) {
        super(resourceOwnerName, dirty);
        if (masterTimeout != null) {
            HashMap<String, String> parameters = new HashMap<String, String>(baseParameters.size() + 1);
            parameters.putAll(baseParameters);
            parameters.put("master_timeout", masterTimeout.toString());
            this.parameters = Collections.unmodifiableMap(parameters);
        } else {
            this.parameters = baseParameters;
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    protected final boolean doCheckAndPublish(RestClient client) {
        CheckResponse check = this.doCheck(client);
        return check != CheckResponse.ERROR && (check == CheckResponse.EXISTS || this.doPublish(client));
    }

    protected abstract CheckResponse doCheck(RestClient var1);

    protected CheckResponse simpleCheckForResource(RestClient client, Logger logger, String resourceBasePath, String resourceName, String resourceType, String resourceOwnerName, String resourceOwnerType) {
        return (CheckResponse)((Object)this.checkForResource(client, logger, resourceBasePath, resourceName, resourceType, resourceOwnerName, resourceOwnerType, GET_EXISTS, GET_DOES_NOT_EXIST).v1());
    }

    protected Tuple<CheckResponse, Response> checkForResource(RestClient client, Logger logger, String resourceBasePath, String resourceName, String resourceType, String resourceOwnerName, String resourceOwnerType, Set<Integer> exists, Set<Integer> doesNotExist) {
        logger.trace("checking if {} [{}] exists on the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
        Set expectedResponseCodes = Sets.union(exists, doesNotExist);
        HashMap<String, String> getParameters = new HashMap<String, String>(this.parameters);
        getParameters.put("ignore", expectedResponseCodes.stream().map(i -> i.toString()).collect(Collectors.joining(",")));
        try {
            Response response = client.performRequest("GET", resourceBasePath + "/" + resourceName, getParameters, new Header[0]);
            int statusCode = response.getStatusLine().getStatusCode();
            if (exists.contains(statusCode)) {
                logger.debug("{} [{}] found on the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
                return new Tuple((Object)CheckResponse.EXISTS, (Object)response);
            }
            if (doesNotExist.contains(statusCode)) {
                logger.debug("{} [{}] does not exist on the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
                return new Tuple((Object)CheckResponse.DOES_NOT_EXIST, (Object)response);
            }
            throw new ResponseException(response);
        }
        catch (ResponseException e) {
            Response response = e.getResponse();
            int statusCode = response.getStatusLine().getStatusCode();
            logger.error(() -> new ParameterizedMessage("failed to verify {} [{}] on the [{}] {} with status code [{}]", new Object[]{resourceType, resourceName, resourceOwnerName, resourceOwnerType, statusCode}), (Throwable)e);
            return new Tuple((Object)CheckResponse.ERROR, (Object)response);
        }
        catch (IOException | RuntimeException e) {
            logger.error(() -> new ParameterizedMessage("failed to verify {} [{}] on the [{}] {}", new Object[]{resourceType, resourceName, resourceOwnerName, resourceOwnerType}), (Throwable)e);
            return new Tuple((Object)CheckResponse.ERROR, null);
        }
    }

    protected abstract boolean doPublish(RestClient var1);

    protected boolean putResource(RestClient client, Logger logger, String resourceBasePath, String resourceName, Supplier<HttpEntity> body, String resourceType, String resourceOwnerName, String resourceOwnerType) {
        logger.trace("uploading {} [{}] to the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
        boolean success = false;
        try {
            Response response = client.performRequest("PUT", resourceBasePath + "/" + resourceName, this.parameters, body.get(), new Header[0]);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != RestStatus.OK.getStatus() && statusCode != RestStatus.CREATED.getStatus()) {
                throw new RuntimeException("[" + resourceBasePath + "/" + resourceName + "] responded with [" + statusCode + "]");
            }
            logger.debug("{} [{}] uploaded to the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
            success = true;
        }
        catch (IOException | RuntimeException e) {
            logger.error(() -> new ParameterizedMessage("failed to upload {} [{}] on the [{}] {}", new Object[]{resourceType, resourceName, resourceOwnerName, resourceOwnerType}), (Throwable)e);
        }
        return success;
    }

    protected boolean deleteResource(RestClient client, Logger logger, String resourceBasePath, String resourceName, String resourceType, String resourceOwnerName, String resourceOwnerType) {
        logger.trace("deleting {} [{}] from the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
        boolean success = false;
        HashMap<String, String> deleteParameters = new HashMap<String, String>(this.parameters);
        deleteParameters.putIfAbsent("ignore", Integer.toString(RestStatus.NOT_FOUND.getStatus()));
        try {
            Response response = client.performRequest("DELETE", resourceBasePath + "/" + resourceName, deleteParameters, new Header[0]);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != RestStatus.OK.getStatus() && statusCode != RestStatus.NOT_FOUND.getStatus()) {
                throw new RuntimeException("[" + resourceBasePath + "/" + resourceName + "] responded with [" + statusCode + "]");
            }
            logger.debug("{} [{}] deleted from the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
            success = true;
        }
        catch (IOException | RuntimeException e) {
            logger.error(() -> new ParameterizedMessage("failed to delete {} [{}] on the [{}] {}", new Object[]{resourceType, resourceName, resourceOwnerName, resourceOwnerType}), (Throwable)e);
        }
        return success;
    }

    public static enum CheckResponse {
        EXISTS,
        DOES_NOT_EXIST,
        ERROR;

    }
}

