/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;

public abstract class Exporter
implements AutoCloseable {
    public static final String EXPORT_PIPELINE_NAME = "xpack_monitoring_2";
    public static final String INDEX_NAME_TIME_FORMAT_SETTING = "index.name.time_format";
    public static final String USE_INGEST_PIPELINE_SETTING = "use_ingest";
    public static final String CLUSTER_ALERTS_MANAGEMENT_SETTING = "cluster_alerts.management.enabled";
    protected final Config config;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public Exporter(Config config) {
        this.config = config;
    }

    public String name() {
        return this.config.name;
    }

    public Config config() {
        return this.config;
    }

    public boolean isSingleton() {
        return false;
    }

    public abstract ExportBulk openBulk();

    protected final boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            this.doClose();
        }
    }

    protected abstract void doClose();

    protected static String settingFQN(Config config) {
        return MonitoringSettings.EXPORTERS_SETTINGS.getKey() + config.name;
    }

    protected static String settingFQN(Config config, String setting) {
        return MonitoringSettings.EXPORTERS_SETTINGS.getKey() + config.name + "." + setting;
    }

    public static XContentBuilder emptyPipeline(XContentType type) {
        try {
            return XContentBuilder.builder((XContent)type.xContent()).startObject().field("description", "2: This is a placeholder pipeline for Monitoring API version 2 so that future versions may fix breaking changes.").startArray("processors").endArray().endObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create empty pipeline", e);
        }
    }

    public static interface Factory {
        public Exporter create(Config var1);
    }

    public static class Config {
        private final String name;
        private final String type;
        private final boolean enabled;
        private final Settings globalSettings;
        private final Settings settings;
        private final ClusterService clusterService;
        private final XPackLicenseState licenseState;

        public Config(String name, String type, Settings globalSettings, Settings settings, ClusterService clusterService, XPackLicenseState licenseState) {
            this.name = name;
            this.type = type;
            this.globalSettings = globalSettings;
            this.settings = settings;
            this.clusterService = clusterService;
            this.licenseState = licenseState;
            this.enabled = settings.getAsBoolean("enabled", Boolean.valueOf(true));
        }

        public String name() {
            return this.name;
        }

        public String type() {
            return this.type;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Settings globalSettings() {
            return this.globalSettings;
        }

        public Settings settings() {
            return this.settings;
        }

        public ClusterService clusterService() {
            return this.clusterService;
        }

        public XPackLicenseState licenseState() {
            return this.licenseState;
        }
    }
}

