/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.action;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.monitoring.action.MonitoringIndex;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class MonitoringBulkDoc
extends MonitoringDoc
implements Writeable {
    private MonitoringIndex index;
    private String type;
    private String id;
    private BytesReference source;
    private XContentType xContentType;

    public MonitoringBulkDoc(String monitoringId, String monitoringVersion, MonitoringIndex index, String type, String id, String clusterUUID, long timestamp, MonitoringDoc.Node sourceNode, BytesReference source, XContentType xContentType) {
        super(monitoringId, monitoringVersion, type, id, clusterUUID, timestamp, sourceNode);
        this.index = index != null ? index : MonitoringIndex.TIMESTAMPED;
        this.type = type;
        this.id = id;
        this.source = source;
        this.xContentType = xContentType;
    }

    public MonitoringBulkDoc(String monitoringId, String monitoringVersion, MonitoringIndex index, String type, String id, BytesReference source, XContentType xContentType) {
        this(monitoringId, monitoringVersion, index, type, id, null, 0L, null, source, xContentType);
    }

    public static MonitoringBulkDoc readFrom(StreamInput in) throws IOException {
        String monitoringId = in.readOptionalString();
        String monitoringVersion = in.readOptionalString();
        String clusterUUID = in.readOptionalString();
        long timestamp = in.readVLong();
        MonitoringDoc.Node sourceNode = (MonitoringDoc.Node)in.readOptionalWriteable(MonitoringDoc.Node::new);
        MonitoringIndex index = MonitoringIndex.readFrom(in);
        String type = in.readOptionalString();
        String id = in.readOptionalString();
        BytesReference source = in.readBytesReference();
        XContentType xContentType = source != BytesArray.EMPTY && in.getVersion().onOrAfter(Version.V_5_3_0) ? XContentType.readFrom((StreamInput)in) : XContentFactory.xContentType((BytesReference)source);
        return new MonitoringBulkDoc(monitoringId, monitoringVersion, index, type, id, clusterUUID, timestamp, sourceNode, source, xContentType);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.getMonitoringId());
        out.writeOptionalString(this.getMonitoringVersion());
        out.writeOptionalString(this.getClusterUUID());
        out.writeVLong(this.getTimestamp());
        out.writeOptionalWriteable((Writeable)this.getSourceNode());
        this.index.writeTo(out);
        out.writeOptionalString(this.type);
        out.writeOptionalString(this.id);
        out.writeBytesReference(this.source);
        if (this.source != null && this.source != BytesArray.EMPTY && out.getVersion().onOrAfter(Version.V_5_3_0)) {
            this.xContentType.writeTo(out);
        }
    }

    public MonitoringIndex getIndex() {
        return this.index;
    }

    public void setIndex(MonitoringIndex index) {
        this.index = index;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public BytesReference getSource() {
        return this.source;
    }

    public void setSource(BytesReference source, XContentType xContentType) {
        this.source = source;
        this.xContentType = xContentType;
    }

    @Override
    public XContentType getXContentType() {
        return this.xContentType;
    }
}

