/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.params;

import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.TimeRange;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.utils.time.TimeUtils;

public class InterimResultsParams {
    private final boolean calcInterim;
    private final TimeRange timeRange;
    private final Long advanceTimeSeconds;

    private InterimResultsParams(boolean calcInterim, TimeRange timeRange, Long advanceTimeSeconds) {
        this.calcInterim = calcInterim;
        this.timeRange = Objects.requireNonNull(timeRange);
        this.advanceTimeSeconds = advanceTimeSeconds;
    }

    public boolean shouldCalculateInterim() {
        return this.calcInterim;
    }

    public boolean shouldAdvanceTime() {
        return this.advanceTimeSeconds != null;
    }

    public String getStart() {
        return this.timeRange.getStart();
    }

    public String getEnd() {
        return this.timeRange.getEnd();
    }

    public long getAdvanceTime() {
        if (!this.shouldAdvanceTime()) {
            throw new IllegalStateException();
        }
        return this.advanceTimeSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterimResultsParams that = (InterimResultsParams)o;
        return this.calcInterim == that.calcInterim && Objects.equals(this.timeRange, that.timeRange) && Objects.equals(this.advanceTimeSeconds, that.advanceTimeSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.calcInterim, this.timeRange, this.advanceTimeSeconds);
    }

    public static class Builder {
        private boolean calcInterim = false;
        private TimeRange timeRange = TimeRange.builder().build();
        private String advanceTime = "";

        private Builder() {
        }

        public Builder calcInterim(boolean value) {
            this.calcInterim = value;
            return this;
        }

        public Builder forTimeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public Builder advanceTime(String timestamp) {
            this.advanceTime = ExceptionsHelper.requireNonNull(timestamp, "advance");
            return this;
        }

        public InterimResultsParams build() {
            this.checkValidFlushArgumentsCombination();
            Long advanceTimeSeconds = this.checkAdvanceTimeParam();
            return new InterimResultsParams(this.calcInterim, this.timeRange, advanceTimeSeconds);
        }

        private void checkValidFlushArgumentsCombination() {
            if (!this.calcInterim) {
                this.checkFlushParamIsEmpty("start", this.timeRange.getStart());
                this.checkFlushParamIsEmpty("end", this.timeRange.getEnd());
            } else if (!this.isValidTimeRange(this.timeRange)) {
                String msg = Messages.getMessage("Invalid flush parameters: ''{0}'' has not been specified.", "start");
                throw new IllegalArgumentException(msg);
            }
        }

        private Long checkAdvanceTimeParam() {
            if (this.advanceTime != null && !this.advanceTime.isEmpty()) {
                return this.paramToEpochIfValidOrThrow("advance_time", this.advanceTime) / 1000L;
            }
            return null;
        }

        private long paramToEpochIfValidOrThrow(String paramName, String date) {
            if ("now".equals(date)) {
                return System.currentTimeMillis();
            }
            long epoch = 0L;
            if (!date.isEmpty() && (epoch = TimeUtils.dateStringToEpoch(date)) < 0L) {
                String msg = Messages.getMessage("Query param ''{0}'' with value ''{1}'' cannot be parsed as a date or converted to a number (epoch).", paramName, date);
                throw new ElasticsearchParseException(msg, new Object[0]);
            }
            return epoch;
        }

        private void checkFlushParamIsEmpty(String paramName, String paramValue) {
            if (!paramValue.isEmpty()) {
                String msg = Messages.getMessage("Invalid flush parameters: unexpected ''{0}''.", paramName);
                throw new IllegalArgumentException(msg);
            }
        }

        private boolean isValidTimeRange(TimeRange timeRange) {
            return !timeRange.getStart().isEmpty() || timeRange.getStart().isEmpty() && timeRange.getEnd().isEmpty();
        }
    }
}

