/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.output;

import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class FlushListener {
    final ConcurrentMap<String, CountDownLatch> awaitingFlushed = new ConcurrentHashMap<String, CountDownLatch>();
    final AtomicBoolean cleared = new AtomicBoolean(false);

    FlushListener() {
    }

    boolean waitForFlush(String flushId, Duration timeout) {
        if (this.cleared.get()) {
            return false;
        }
        CountDownLatch latch = this.awaitingFlushed.computeIfAbsent(flushId, key -> new CountDownLatch(1));
        try {
            return latch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    void acknowledgeFlush(String flushId) {
        CountDownLatch latch = this.awaitingFlushed.computeIfAbsent(flushId, key -> new CountDownLatch(1));
        latch.countDown();
    }

    void clear(String flushId) {
        this.awaitingFlushed.remove(flushId);
    }

    void clear() {
        if (this.cleared.compareAndSet(false, true)) {
            Iterator latches = this.awaitingFlushed.entrySet().iterator();
            while (latches.hasNext()) {
                ((CountDownLatch)latches.next().getValue()).countDown();
                latches.remove();
            }
        }
    }
}

