/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.ml.job.config.DataDescription;
import org.elasticsearch.xpack.ml.job.config.Job;

public class ProcessCtrl {
    public static final String AUTODETECT = "autodetect";
    static final String AUTODETECT_PATH = "./autodetect";
    public static final String NORMALIZE = "normalize";
    static final String NORMALIZE_PATH = "./normalize";
    public static final String CONTROLLER = "controller";
    private static final int DEFAULT_MAX_NUM_RECORDS = 500;
    public static final Setting<Integer> MAX_ANOMALY_RECORDS_SETTING = Setting.intSetting((String)"max.anomaly.records", (int)500, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final long VALIDATION_NUMBER = 926213L;
    static final String JOB_ID_ARG = "--jobid=";
    static final String LICENSE_VALIDATION_ARG = "--licenseValidation=";
    static final String BUCKET_SPAN_ARG = "--bucketspan=";
    public static final String DELETE_STATE_FILES_ARG = "--deleteStateFiles";
    static final String IGNORE_DOWNTIME_ARG = "--ignoreDowntime";
    static final String LENGTH_ENCODED_INPUT_ARG = "--lengthEncodedInput";
    static final String MODEL_CONFIG_ARG = "--modelconfig=";
    public static final String QUANTILES_STATE_PATH_ARG = "--quantilesState=";
    static final String MULTIPLE_BUCKET_SPANS_ARG = "--multipleBucketspans=";
    static final String PER_PARTITION_NORMALIZATION = "--perPartitionNormalization";
    static final String LATENCY_ARG = "--latency=";
    static final String RESULT_FINALIZATION_WINDOW_ARG = "--resultFinalizationWindow=";
    static final String MULTIVARIATE_BY_FIELDS_ARG = "--multivariateByFields";
    static final String PERSIST_INTERVAL_ARG = "--persistInterval=";
    static final String MAX_QUANTILE_INTERVAL_ARG = "--maxQuantileInterval=";
    static final String SUMMARY_COUNT_FIELD_ARG = "--summarycountfield=";
    static final String TIME_FIELD_ARG = "--timefield=";
    private static final int SECONDS_IN_HOUR = 3600;
    static final long DEFAULT_BASE_PERSIST_INTERVAL = 10800L;
    static final int BASE_MAX_QUANTILE_INTERVAL = 21600;
    static final String ML_MODEL_CONF = "mlmodel.conf";
    private static final String QUANTILES_FILE_EXTENSION = ".json";
    public static final Setting<Boolean> DONT_PERSIST_MODEL_STATE_SETTING = Setting.boolSetting((String)"no.model.state.persist", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    static String maxAnomalyRecordsArg(Settings settings) {
        return "--maxAnomalyRecords=" + MAX_ANOMALY_RECORDS_SETTING.get(settings);
    }

    private ProcessCtrl() {
    }

    static int calculateStaggeringInterval(String jobId) {
        Random rng = new Random(jobId.hashCode());
        return rng.nextInt(3600);
    }

    public static List<String> buildAutodetectCommand(Environment env, Settings settings, Job job, Logger logger, boolean ignoreDowntime, long controllerPid) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(AUTODETECT_PATH);
        String jobId = JOB_ID_ARG + job.getId();
        command.add(jobId);
        command.add(ProcessCtrl.makeLicenseArg(controllerPid));
        AnalysisConfig analysisConfig = job.getAnalysisConfig();
        if (analysisConfig != null) {
            ProcessCtrl.addIfNotNull(analysisConfig.getBucketSpan(), BUCKET_SPAN_ARG, command);
            ProcessCtrl.addIfNotNull(analysisConfig.getLatency(), LATENCY_ARG, command);
            ProcessCtrl.addIfNotNull(analysisConfig.getSummaryCountFieldName(), SUMMARY_COUNT_FIELD_ARG, command);
            ProcessCtrl.addIfNotNull(analysisConfig.getMultipleBucketSpans(), MULTIPLE_BUCKET_SPANS_ARG, command);
            if (Boolean.TRUE.equals(analysisConfig.getOverlappingBuckets())) {
                Long window = analysisConfig.getResultFinalizationWindow();
                if (window == null) {
                    window = 2L;
                }
                command.add(RESULT_FINALIZATION_WINDOW_ARG + window);
            }
            if (Boolean.TRUE.equals(analysisConfig.getMultivariateByFields())) {
                command.add(MULTIVARIATE_BY_FIELDS_ARG);
            }
            if (analysisConfig.getUsePerPartitionNormalization()) {
                command.add(PER_PARTITION_NORMALIZATION);
            }
        }
        command.add(LENGTH_ENCODED_INPUT_ARG);
        command.add(ProcessCtrl.maxAnomalyRecordsArg(settings));
        String timeFieldArg = TIME_FIELD_ARG + ProcessCtrl.getTimeFieldOrDefault(job);
        command.add(timeFieldArg);
        int intervalStagger = ProcessCtrl.calculateStaggeringInterval(job.getId());
        logger.debug("Periodic operations staggered by " + intervalStagger + " seconds for job '" + job.getId() + "'");
        if (((Boolean)DONT_PERSIST_MODEL_STATE_SETTING.get(settings)).booleanValue()) {
            logger.info("Will not persist model state - " + DONT_PERSIST_MODEL_STATE_SETTING + " setting was set");
        } else {
            long persistInterval = job.getBackgroundPersistInterval() == null ? 10800L + (long)intervalStagger : job.getBackgroundPersistInterval().getSeconds();
            command.add(PERSIST_INTERVAL_ARG + persistInterval);
        }
        int maxQuantileInterval = 21600 + intervalStagger;
        command.add(MAX_QUANTILE_INTERVAL_ARG + maxQuantileInterval);
        if (ignoreDowntime) {
            command.add(IGNORE_DOWNTIME_ARG);
        }
        if (ProcessCtrl.modelConfigFilePresent(env)) {
            String modelConfigFile = XPackPlugin.resolveConfigFile(env, ML_MODEL_CONF).toString();
            command.add(MODEL_CONFIG_ARG + modelConfigFile);
        }
        return command;
    }

    private static String getTimeFieldOrDefault(Job job) {
        DataDescription dataDescription = job.getDataDescription();
        boolean useDefault = dataDescription == null || Strings.isNullOrEmpty((String)dataDescription.getTimeField());
        return useDefault ? "time" : dataDescription.getTimeField();
    }

    private static void addIfNotNull(TimeValue timeValue, String argKey, List<String> command) {
        ProcessCtrl.addIfNotNull(timeValue == null ? null : Long.valueOf(timeValue.getSeconds()), argKey, command);
    }

    private static void addIfNotNull(List<TimeValue> timeValues, String argKey, List<String> command) {
        if (timeValues != null) {
            ProcessCtrl.addIfNotNull(timeValues.stream().map(v -> v.getSeconds()).collect(Collectors.toList()), argKey, command);
        }
    }

    private static <T> void addIfNotNull(T object, String argKey, List<String> command) {
        if (object != null) {
            String param = argKey + object;
            command.add(param);
        }
    }

    public static boolean modelConfigFilePresent(Environment env) {
        Path modelConfPath = XPackPlugin.resolveConfigFile(env, ML_MODEL_CONF);
        return Files.isRegularFile(modelConfPath, new LinkOption[0]);
    }

    public static List<String> buildNormalizerCommand(Environment env, String jobId, String quantilesState, Integer bucketSpan, boolean perPartitionNormalization, long controllerPid) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(NORMALIZE_PATH);
        ProcessCtrl.addIfNotNull(bucketSpan, BUCKET_SPAN_ARG, command);
        command.add(ProcessCtrl.makeLicenseArg(controllerPid));
        command.add(LENGTH_ENCODED_INPUT_ARG);
        if (perPartitionNormalization) {
            command.add(PER_PARTITION_NORMALIZATION);
        }
        if (quantilesState != null) {
            Path quantilesStateFilePath = ProcessCtrl.writeNormalizerInitState(jobId, quantilesState, env);
            String stateFileArg = QUANTILES_STATE_PATH_ARG + quantilesStateFilePath;
            command.add(stateFileArg);
            command.add(DELETE_STATE_FILES_ARG);
        }
        if (ProcessCtrl.modelConfigFilePresent(env)) {
            String modelConfigFile = XPackPlugin.resolveConfigFile(env, ML_MODEL_CONF).toString();
            command.add(MODEL_CONFIG_ARG + modelConfigFile);
        }
        return command;
    }

    public static Path writeNormalizerInitState(String jobId, String state, Environment env) throws IOException {
        Path stateFile = Files.createTempFile(env.tmpFile(), jobId + "_quantiles_" + Thread.currentThread().getId(), QUANTILES_FILE_EXTENSION, new FileAttribute[0]);
        try (BufferedWriter osw = Files.newBufferedWriter(stateFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            osw.write(state);
        }
        return stateFile;
    }

    private static String makeLicenseArg(long controllerPid) {
        long rand = Randomness.get().nextInt();
        long val = controllerPid + ((rand < 0L ? -rand : rand) + 1L) * 926213L;
        return LICENSE_VALIDATION_ARG + val;
    }
}

