/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

public final class RecordsQueryBuilder {
    public static final int DEFAULT_SIZE = 100;
    private RecordsQuery recordsQuery = new RecordsQuery();

    public RecordsQueryBuilder from(int from) {
        this.recordsQuery.from = from;
        return this;
    }

    public RecordsQueryBuilder size(int size) {
        this.recordsQuery.size = size;
        return this;
    }

    public RecordsQueryBuilder epochStart(String startTime) {
        this.recordsQuery.start = startTime;
        return this;
    }

    public RecordsQueryBuilder epochEnd(String endTime) {
        this.recordsQuery.end = endTime;
        return this;
    }

    public RecordsQueryBuilder includeInterim(boolean include) {
        this.recordsQuery.includeInterim = include;
        return this;
    }

    public RecordsQueryBuilder sortField(String fieldname) {
        this.recordsQuery.sortField = fieldname;
        return this;
    }

    public RecordsQueryBuilder sortDescending(boolean sortDescending) {
        this.recordsQuery.sortDescending = sortDescending;
        return this;
    }

    public RecordsQueryBuilder recordScore(double recordScore) {
        this.recordsQuery.recordScore = recordScore;
        return this;
    }

    public RecordsQueryBuilder partitionFieldValue(String partitionFieldValue) {
        this.recordsQuery.partitionFieldValue = partitionFieldValue;
        return this;
    }

    public RecordsQuery build() {
        return this.recordsQuery;
    }

    public void clear() {
        this.recordsQuery = new RecordsQuery();
    }

    public class RecordsQuery {
        private int from = 0;
        private int size = 100;
        private boolean includeInterim = false;
        private String sortField;
        private boolean sortDescending = true;
        private double recordScore = 0.0;
        private String partitionFieldValue;
        private String start;
        private String end;

        public int getSize() {
            return this.size;
        }

        public boolean isIncludeInterim() {
            return this.includeInterim;
        }

        public String getSortField() {
            return this.sortField;
        }

        public boolean isSortDescending() {
            return this.sortDescending;
        }

        public double getRecordScoreThreshold() {
            return this.recordScore;
        }

        public String getPartitionFieldValue() {
            return this.partitionFieldValue;
        }

        public int getFrom() {
            return this.from;
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }
    }
}

