/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.ml.job.results.Result;

public final class BucketsQueryBuilder {
    public static final int DEFAULT_SIZE = 100;
    private BucketsQuery bucketsQuery = new BucketsQuery();

    public BucketsQueryBuilder from(int from) {
        this.bucketsQuery.from = from;
        return this;
    }

    public BucketsQueryBuilder size(int size) {
        this.bucketsQuery.size = size;
        return this;
    }

    public BucketsQueryBuilder expand(boolean expand) {
        this.bucketsQuery.expand = expand;
        return this;
    }

    public BucketsQueryBuilder includeInterim(boolean include) {
        this.bucketsQuery.includeInterim = include;
        return this;
    }

    public BucketsQueryBuilder anomalyScoreThreshold(Double anomalyScoreFilter) {
        if (anomalyScoreFilter != null) {
            this.bucketsQuery.anomalyScoreFilter = anomalyScoreFilter;
        }
        return this;
    }

    public BucketsQueryBuilder partitionValue(String partitionValue) {
        if (!Strings.isNullOrEmpty((String)partitionValue)) {
            this.bucketsQuery.partitionValue = partitionValue;
        }
        return this;
    }

    public BucketsQueryBuilder sortField(String sortField) {
        this.bucketsQuery.sortField = sortField;
        return this;
    }

    public BucketsQueryBuilder sortDescending(boolean sortDescending) {
        this.bucketsQuery.sortDescending = sortDescending;
        return this;
    }

    public BucketsQueryBuilder start(String startTime) {
        this.bucketsQuery.start = startTime;
        return this;
    }

    public BucketsQueryBuilder end(String endTime) {
        this.bucketsQuery.end = endTime;
        return this;
    }

    public BucketsQueryBuilder timestamp(String timestamp) {
        this.bucketsQuery.timestamp = timestamp;
        this.bucketsQuery.size = 1;
        return this;
    }

    public BucketsQuery build() {
        if (this.bucketsQuery.timestamp != null && (this.bucketsQuery.start != null || this.bucketsQuery.end != null)) {
            throw new IllegalStateException("Either specify timestamp or start/end");
        }
        return this.bucketsQuery;
    }

    public void clear() {
        this.bucketsQuery = new BucketsQuery();
    }

    public class BucketsQuery {
        private int from = 0;
        private int size = 100;
        private boolean expand = false;
        private boolean includeInterim = false;
        private double anomalyScoreFilter = 0.0;
        private String start;
        private String end;
        private String timestamp;
        private String partitionValue = null;
        private String sortField = Result.TIMESTAMP.getPreferredName();
        private boolean sortDescending = false;

        public int getFrom() {
            return this.from;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isExpand() {
            return this.expand;
        }

        public boolean isIncludeInterim() {
            return this.includeInterim;
        }

        public double getAnomalyScoreFilter() {
            return this.anomalyScoreFilter;
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getPartitionValue() {
            return this.partitionValue;
        }

        public String getSortField() {
            return this.sortField;
        }

        public boolean isSortDescending() {
            return this.sortDescending;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.size, this.expand, this.includeInterim, this.anomalyScoreFilter, this.start, this.end, this.timestamp, this.partitionValue, this.sortField, this.sortDescending);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BucketsQuery other = (BucketsQuery)obj;
            return Objects.equals(this.from, other.from) && Objects.equals(this.size, other.size) && Objects.equals(this.expand, other.expand) && Objects.equals(this.includeInterim, other.includeInterim) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.anomalyScoreFilter, other.anomalyScoreFilter) && Objects.equals(this.partitionValue, other.partitionValue) && Objects.equals(this.sortField, other.sortField) && this.sortDescending == other.sortDescending;
        }
    }
}

