/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.xpack.ml.MlMetadata;

public final class AnomalyDetectorsIndex {
    public static final String ML_META_INDEX = ".ml-meta";
    public static final String RESULTS_INDEX_PREFIX = ".ml-anomalies-";
    private static final String STATE_INDEX_NAME = ".ml-state";
    public static final String RESULTS_INDEX_DEFAULT = "shared";

    private AnomalyDetectorsIndex() {
    }

    public static String jobResultsIndexPrefix() {
        return RESULTS_INDEX_PREFIX;
    }

    public static String jobResultsAliasedName(String jobId) {
        return RESULTS_INDEX_PREFIX + jobId;
    }

    public static String getPhysicalIndexFromState(ClusterState state, String jobId) {
        MlMetadata meta = (MlMetadata)state.getMetaData().custom("ml");
        return meta.getJobs().get(jobId).getResultsIndexName();
    }

    public static String jobStateIndexName() {
        return STATE_INDEX_NAME;
    }
}

