/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job;

import java.util.concurrent.LinkedBlockingQueue;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ml.action.UpdateProcessAction;
import org.elasticsearch.xpack.ml.job.config.JobUpdate;

public class UpdateJobProcessNotifier
extends AbstractComponent
implements LocalNodeMasterListener {
    private final Client client;
    private final ThreadPool threadPool;
    private final LinkedBlockingQueue<JobUpdate> orderedJobUpdates = new LinkedBlockingQueue(1000);
    private volatile ThreadPool.Cancellable cancellable;

    public UpdateJobProcessNotifier(Settings settings, Client client, ClusterService clusterService, ThreadPool threadPool) {
        super(settings);
        this.client = client;
        this.threadPool = threadPool;
        clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                UpdateJobProcessNotifier.this.stop();
            }
        });
    }

    boolean submitJobUpdate(JobUpdate jobUpdate) {
        return this.orderedJobUpdates.offer(jobUpdate);
    }

    public void onMaster() {
        this.start();
    }

    public void offMaster() {
        this.stop();
    }

    void start() {
        this.cancellable = this.threadPool.scheduleWithFixedDelay(this::processNextUpdate, TimeValue.timeValueSeconds((long)1L), "generic");
    }

    void stop() {
        this.orderedJobUpdates.clear();
        ThreadPool.Cancellable cancellable = this.cancellable;
        if (cancellable != null) {
            cancellable.cancel();
        }
    }

    public String executorName() {
        return "same";
    }

    void processNextUpdate() {
        try {
            JobUpdate jobUpdate = this.orderedJobUpdates.poll();
            if (jobUpdate != null) {
                this.executeRemoteJob(jobUpdate);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable while processing next job update", (Throwable)e);
        }
    }

    void executeRemoteJob(final JobUpdate update) {
        UpdateProcessAction.Request request = new UpdateProcessAction.Request(update.getJobId(), update.getModelPlotConfig(), update.getDetectorUpdates());
        this.client.execute((Action)UpdateProcessAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<UpdateProcessAction.Response>(){

            public void onResponse(UpdateProcessAction.Response response) {
                if (response.isUpdated()) {
                    UpdateJobProcessNotifier.this.logger.info("Successfully updated remote job [{}]", (Object)update.getJobId());
                } else {
                    UpdateJobProcessNotifier.this.logger.error("Failed to update remote job [{}]", (Object)update.getJobId());
                }
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceNotFoundException) {
                    UpdateJobProcessNotifier.this.logger.debug("Remote job [{}] not updated as it has been deleted", (Object)update.getJobId());
                } else if (e.getMessage().contains("because job [" + update.getJobId() + "] is not open") && e instanceof ElasticsearchStatusException) {
                    UpdateJobProcessNotifier.this.logger.debug("Remote job [{}] not updated as it is no longer open", (Object)update.getJobId());
                } else {
                    UpdateJobProcessNotifier.this.logger.error("Failed to update remote job [" + update.getJobId() + "]", (Throwable)e);
                }
            }
        });
    }
}

