/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.scroll;

import java.util.Objects;
import org.elasticsearch.client.Client;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ExtractedFields;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ScrollDataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ScrollDataExtractorContext;
import org.elasticsearch.xpack.ml.job.config.Job;

public class ScrollDataExtractorFactory
implements DataExtractorFactory {
    private final Client client;
    private final DatafeedConfig datafeedConfig;
    private final Job job;
    private final ExtractedFields extractedFields;

    public ScrollDataExtractorFactory(Client client, DatafeedConfig datafeedConfig, Job job) {
        this.client = Objects.requireNonNull(client);
        this.datafeedConfig = Objects.requireNonNull(datafeedConfig);
        this.job = Objects.requireNonNull(job);
        this.extractedFields = ExtractedFields.build(job, datafeedConfig);
    }

    @Override
    public DataExtractor newExtractor(long start, long end) {
        ScrollDataExtractorContext dataExtractorContext = new ScrollDataExtractorContext(this.job.getId(), this.extractedFields, this.datafeedConfig.getIndexes(), this.datafeedConfig.getTypes(), this.datafeedConfig.getQuery(), this.datafeedConfig.getScriptFields(), this.datafeedConfig.getScrollSize(), start, end);
        return new ScrollDataExtractor(this.client, dataExtractorContext);
    }
}

