/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.scroll;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ExtractedField;
import org.elasticsearch.xpack.ml.job.config.Job;

class ExtractedFields {
    private final ExtractedField timeField;
    private final List<ExtractedField> allFields;

    ExtractedFields(ExtractedField timeField, List<ExtractedField> allFields) {
        if (!allFields.contains(timeField)) {
            throw new IllegalArgumentException("timeField should also be contained in allFields");
        }
        this.timeField = Objects.requireNonNull(timeField);
        this.allFields = Collections.unmodifiableList(allFields);
    }

    public List<ExtractedField> getAllFields() {
        return this.allFields;
    }

    public String[] getSourceFields() {
        return this.filterFields(ExtractedField.ExtractionMethod.SOURCE);
    }

    public String[] getDocValueFields() {
        return this.filterFields(ExtractedField.ExtractionMethod.DOC_VALUE);
    }

    private String[] filterFields(ExtractedField.ExtractionMethod method) {
        ArrayList<String> result = new ArrayList<String>();
        for (ExtractedField field : this.allFields) {
            if (field.getExtractionMethod() != method) continue;
            result.add(field.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public String timeField() {
        return this.timeField.getName();
    }

    public Long timeFieldValue(SearchHit hit) {
        Object[] value = this.timeField.value(hit);
        if (value.length != 1) {
            throw new RuntimeException("Time field [" + this.timeField.getName() + "] expected a single value; actual was: " + Arrays.toString(value));
        }
        if (value[0] instanceof Long) {
            return (Long)value[0];
        }
        throw new RuntimeException("Time field [" + this.timeField.getName() + "] expected a long value; actual was: " + value[0]);
    }

    public static ExtractedFields build(Job job, DatafeedConfig datafeedConfig) {
        String timeField;
        Set scriptFields = datafeedConfig.getScriptFields().stream().map(sf -> sf.fieldName()).collect(Collectors.toSet());
        ExtractedField timeExtractedField = ExtractedField.newField(timeField, scriptFields.contains(timeField = job.getDataDescription().getTimeField()) ? ExtractedField.ExtractionMethod.SCRIPT_FIELD : ExtractedField.ExtractionMethod.DOC_VALUE);
        List remainingFields = job.allFields().stream().filter(f -> !f.equals(timeField)).collect(Collectors.toList());
        ArrayList<ExtractedField> allExtractedFields = new ArrayList<ExtractedField>(remainingFields.size());
        allExtractedFields.add(timeExtractedField);
        for (String field : remainingFields) {
            ExtractedField.ExtractionMethod method = scriptFields.contains(field) ? ExtractedField.ExtractionMethod.SCRIPT_FIELD : (datafeedConfig.isSource() ? ExtractedField.ExtractionMethod.SOURCE : ExtractedField.ExtractionMethod.DOC_VALUE);
            allExtractedFields.add(ExtractedField.newField(field, method));
        }
        return new ExtractedFields(timeExtractedField, allExtractedFields);
    }
}

