/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.scroll;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;

abstract class ExtractedField {
    protected final String name;
    private final ExtractionMethod extractionMethod;

    protected ExtractedField(String name, ExtractionMethod extractionMethod) {
        this.name = Objects.requireNonNull(name);
        this.extractionMethod = Objects.requireNonNull(extractionMethod);
    }

    public String getName() {
        return this.name;
    }

    public ExtractionMethod getExtractionMethod() {
        return this.extractionMethod;
    }

    public abstract Object[] value(SearchHit var1);

    public static ExtractedField newField(String name, ExtractionMethod extractionMethod) {
        switch (extractionMethod) {
            case DOC_VALUE: 
            case SCRIPT_FIELD: {
                return new FromFields(name, extractionMethod);
            }
            case SOURCE: {
                return new FromSource(name, extractionMethod);
            }
        }
        throw new IllegalArgumentException("Invalid extraction method [" + (Object)((Object)extractionMethod) + "]");
    }

    private static class FromSource
    extends ExtractedField {
        private String[] namePath;

        FromSource(String name, ExtractionMethod extractionMethod) {
            super(name, extractionMethod);
            this.namePath = name.split("\\.");
        }

        @Override
        public Object[] value(SearchHit hit) {
            Object values;
            int level;
            Map<String, Object> source = hit.getSource();
            for (level = 0; source != null && level < this.namePath.length - 1; ++level) {
                source = FromSource.getNextLevel(source, this.namePath[level]);
            }
            if (source != null && (values = source.get(this.namePath[level])) != null) {
                if (values instanceof List) {
                    List asList = (List)values;
                    return asList.toArray(new Object[asList.size()]);
                }
                return new Object[]{values};
            }
            return new Object[0];
        }

        private static Map<String, Object> getNextLevel(Map<String, Object> source, String key) {
            Object nextLevel = source.get(key);
            if (nextLevel instanceof Map) {
                return (Map)source.get(key);
            }
            return null;
        }
    }

    private static class FromFields
    extends ExtractedField {
        FromFields(String name, ExtractionMethod extractionMethod) {
            super(name, extractionMethod);
        }

        @Override
        public Object[] value(SearchHit hit) {
            SearchHitField keyValue = hit.field(this.name);
            if (keyValue != null) {
                List values = keyValue.values();
                return values.toArray(new Object[values.size()]);
            }
            return new Object[0];
        }
    }

    public static enum ExtractionMethod {
        SOURCE,
        DOC_VALUE,
        SCRIPT_FIELD;

    }
}

